/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.cp.rdf.util;

import java.util.Iterator;

/**
 * An iterator that reads elements from another iterator and maps them to its own elements.
 * 
 * @author msabadello at parityinc dot net
 */
public abstract class MappingIterator implements Iterator {

	protected Iterator iterator;

	public MappingIterator(Iterator iterator) {

		this.iterator = iterator;
	}

	public boolean hasNext() {

		return(this.iterator.hasNext());
	}

	public Object next() {

		return(this.map(this.iterator.next()));
	}

	public void remove() {

		this.iterator.remove();
	}

	public abstract Object map(Object item);
}
