/*******************************************************************************
 * Copyright (c) 2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.cp.rdf.util;

import java.util.Iterator;

/**
 * An iterator that returns only all non-null elements from another iterator.
 * 
 * @author msabadello at parityinc dot net
 */
public class NotNullIterator extends SelectingIterator {

	public NotNullIterator(Iterator iterator) {

		super(iterator);
	}

	public boolean select(Object item) {

		return(item != null);
	}
}
