/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf.RDFEntity;
import org.eclipse.higgins.idas.cp.rdf.RDFProxyEntity;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicValueString;
import org.eclipse.higgins.idas.spi.IValueContainer;

public class RDFAttribute
extends BasicAttribute {
    private Model model;
    private BasicContext containerCtx;
    private Resource resource;
    private Property property;

    RDFAttribute(Model model, BasicContext containerCtx, Resource resource, Property property) throws IdASException {
        super(URI.create(property.getURI()), (IValue)null, null, null);
        this.model = model;
        this.containerCtx = containerCtx;
        this.resource = resource;
        this.property = property;
    }

    public Iterator getValues() throws IdASException {
        return new MappingIterator((Iterator)this.resource.listProperties(this.property)){

            public Object map(Object item) {
                Statement statement = (Statement)item;
                RDFNode object = statement.getObject();
                try {
                    if (object.isLiteral()) {
                        return new BasicValueString(((Literal)object).getString(), (IValueContainer)RDFAttribute.this);
                    }
                    if (object.isResource() && object.isURIResource()) {
                        Resource resource = RDFAttribute.this.model.getResource(((Resource)object).getURI());
                        if (resource != null) {
                            String type = null;
                            if (resource.hasProperty(RDF.type)) {
                                type = ((Resource)resource.listProperties(RDF.type).nextStatement().getObject()).getURI();
                            }
                            return new RDFEntity(RDFAttribute.this.containerCtx, type != null ? URI.create(type) : null, RDFAttribute.this.model, resource);
                        }
                        return new RDFProxyEntity(RDFAttribute.this.containerCtx, ((Resource)object).getURI());
                    }
                    if (object.isResource() && object.isAnon()) {
                        String type = null;
                        if (((Resource)object).hasProperty(RDF.type)) {
                            type = ((Resource)((Resource)object).listProperties(RDF.type).nextStatement().getObject()).getURI();
                        }
                        return new RDFEntity(RDFAttribute.this.containerCtx, type != null ? URI.create(type) : null, RDFAttribute.this.model, RDFAttribute.this.resource);
                    }
                    return null;
                }
                catch (IdASException ex) {
                    return null;
                }
            }
        };
    }
}

