/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.cp.rdf.RDFEntity;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.cp.rdf.util.NotNullIterator;
import org.eclipse.higgins.idas.spi.BasicContext;

public class RDFContext
extends BasicContext {
    public static final String MIME_RDFXML = "application/rdf+xml";
    private URL url;
    private Model model;

    public RDFContext(URL url) throws IdASException {
        this.url = url;
        this.model = null;
    }

    public boolean isOpen(Object authentication) {
        return this.model != null;
    }

    public String open(IAuthNMaterials authentication) throws IdASException, ContextOpenException {
        if (this.isOpen(authentication)) {
            throw new ContextOpenException();
        }
        this.model = ModelFactory.createDefaultModel();
        try {
            String line;
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestProperty("Accept", MIME_RDFXML);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer buffer = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            System.out.println(buffer.toString());
            this.model.read((Reader)new StringReader(buffer.toString()), this.url.toString());
        }
        catch (Exception ex) {
            throw new IdASException("Cannot open " + this.url.toString() + ": " + ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    public void reopen() throws IdASException, AuthenticationException {
        this.close();
        this.open(null);
    }

    public void close() throws IdASException {
        this.model.close();
        this.model = null;
    }

    public IEntity getEntity(String uid) throws IdASException {
        Resource resource;
        if (!this.isOpen(null)) {
            throw new ContextNotOpenException();
        }
        try {
            resource = this.model.getResource(uid);
        }
        catch (Exception ex) {
            throw new IdASException((Throwable)ex);
        }
        if (resource == null) {
            throw new NoSuchEntityException();
        }
        String type = null;
        if (resource.hasProperty(RDF.type)) {
            type = ((Resource)resource.listProperties(RDF.type).nextStatement().getObject()).getURI();
        }
        return new RDFEntity(this, type != null ? URI.create(type) : null, this.model, resource);
    }

    public Iterator getEntities(String query) throws IdASException {
        return this.getEntities(null);
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        return new NotNullIterator(new MappingIterator((Iterator)this.model.listSubjects()){

            public Object map(Object item) {
                Resource resource = (Resource)item;
                if (!resource.isURIResource()) {
                    return null;
                }
                String type = null;
                if (resource.hasProperty(RDF.type)) {
                    type = ((Resource)resource.listProperties(RDF.type).nextStatement().getObject()).getURI();
                }
                try {
                    return new RDFEntity(RDFContext.this, type != null ? URI.create(type) : null, RDFContext.this.model, resource);
                }
                catch (IdASException ex) {
                    return null;
                }
            }
        });
    }
}

