/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.rdf.RDFContext;

public class RDFContextFactory
implements IContextFactory {
    private ISettingDescriptor _contextFactoryDescriptor = null;
    private List _contextTypesList = null;

    public IContext createContext(IContextId contextID) throws IdASException {
        URL url;
        if (contextID == null) {
            throw new IdASException("Parameter \"contextID\" is null.");
        }
        try {
            List uris = (List)contextID.getConfiguration().get("uris");
            URI uri = (URI)uris.get(0);
            url = new URL(uri.toString());
        }
        catch (MalformedURLException ex) {
            throw new IdASException("Malformed URL " + contextID, (Throwable)ex);
        }
        try {
            RDFContext context = new RDFContext(url);
            return context;
        }
        catch (IdASException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IdASException((Throwable)ex);
        }
    }

    public IContext createContext(URL url) throws IdASException {
        if (url == null) {
            throw new IdASException("Parameter \"url\" is null.");
        }
        try {
            RDFContext context = new RDFContext(url);
            return context;
        }
        catch (IdASException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IdASException((Throwable)ex);
        }
    }

    public String getName() throws IdASException {
        return "Higgins RDF Context Provider";
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        if (mapComponentSettings != null) {
            this._contextTypesList = (List)mapComponentSettings.get("ContextTypes");
        }
        this._contextFactoryDescriptor = componentDescriptor;
    }

    public Iterator getContexts(String filter) throws IdASException {
        throw new NotImplementedException();
    }

    public String getPolicy() throws IdASException {
        throw new NotImplementedException();
    }

    public void setPolicy(String policy) throws IdASException {
        throw new NotImplementedException();
    }

    public ISettingDescriptor getComponentDescriptor() {
        return this._contextFactoryDescriptor;
    }

    public List getTypes() throws IdASException {
        return this._contextTypesList;
    }

    public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException {
        return null;
    }
}

