/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf.RDFAttribute;
import org.eclipse.higgins.idas.cp.rdf.util.MappingIterator;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicEntity;

public class RDFEntity
extends BasicEntity {
    private BasicContext containerCtx;
    private Model model;
    private Resource resource;

    public RDFEntity(BasicContext containerCtx, URI type, Model model, Resource resource) throws IdASException {
        super(containerCtx, type, resource.getURI());
        this.containerCtx = containerCtx;
        this.model = model;
        this.resource = resource;
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        if (attrID == null) {
            throw new IdASException("Parameter \"attrID\" is null.");
        }
        PropertyImpl property = new PropertyImpl(attrID.toString());
        if (!this.resource.hasProperty((Property)property)) {
            return null;
        }
        return new RDFAttribute(this.model, this.containerCtx, this.resource, (Property)property);
    }

    public Iterator getAttributes() throws IdASException {
        HashMap<String, Property> map = new HashMap<String, Property>();
        StmtIterator iterator = this.resource.listProperties();
        while (iterator.hasNext()) {
            Statement statement = iterator.nextStatement();
            Property property = statement.getPredicate();
            map.put(property.getURI(), property);
        }
        return new MappingIterator(map.entrySet().iterator()){

            public Object map(Object item) {
                Map.Entry entry = (Map.Entry)item;
                Property property = (Property)entry.getValue();
                try {
                    return new RDFAttribute(RDFEntity.this.model, RDFEntity.this.containerCtx, RDFEntity.this.resource, property);
                }
                catch (IdASException ex) {
                    return null;
                }
            }
        };
    }
}

