/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.cp.rdf2.IStatefulObject;
import org.eclipse.higgins.idas.cp.rdf2.impl.Context;
import org.eclipse.higgins.idas.cp.rdf2.impl.Entity;
import org.eclipse.higgins.idas.cp.rdf2.impl.IEntityReference;
import org.eclipse.higgins.idas.cp.rdf2.impl.SimpleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
implements IAttribute {
    private static Log log = LogFactory.getLog(Attribute.class);
    private Context context;
    private boolean isSimple;
    private boolean isComplex;
    private Entity owner;
    private URI type;
    private ArrayList<IStatefulObject> values;

    public Attribute(Context context, Entity owner, URI type) {
        this.owner = owner;
        this.type = type;
        this.context = context;
    }

    private synchronized void initValues() throws IdASException {
        if (this.values != null) {
            return;
        }
        this.values = new ArrayList();
        Resource subj = this.owner.getSubject();
        if (subj != null) {
            Property property = this.context.getSharedContext().getProperty(this.type.toString());
            StmtIterator itr = subj.listProperties(property);
            while (itr.hasNext()) {
                Statement st = (Statement)itr.next();
                RDFNode obj = st.getObject();
                if (obj.isLiteral()) {
                    this.isSimple = true;
                    Literal lit = (Literal)obj.as(Literal.class);
                    SimpleValue sv = new SimpleValue(this.context, this, lit);
                    this.values.add(sv);
                    continue;
                }
                if (obj.isResource()) {
                    Resource subSubj = (Resource)obj.as(Resource.class);
                    String entityId = subSubj.getURI();
                    Entity ent = this.context.getSessionEntity(entityId);
                    if (ent == null) {
                        ent = new Entity(this.context, subSubj);
                    }
                    IEntityReference ref = new IEntityReference(this, ent, this.context);
                    this.values.add(ref);
                    this.isComplex = true;
                    continue;
                }
                throw new IdASException("Entity with type " + this.owner.getType().toString() + " contains value with unexpected type for attribute " + this.type.toString());
            }
        }
    }

    public Entity getOwner() {
        return this.owner;
    }

    public IEntity addComplexValue(URI type) throws IdASException, InvalidTypeException {
        if (type == null) {
            throw new IdASException("Parameter \"type\" is null.");
        }
        this.initValues();
        if (this.isSimple) {
            throw new IdASException("Could not add complex value. Attribute is simple.");
        }
        Entity ent = new Entity(this.context, type, null);
        this.isComplex = true;
        this.context.registerChangedObject(ent);
        IEntityReference erf = new IEntityReference(this, ent, this.context);
        this.context.registerChangedObject(erf);
        this.values.add(erf);
        return ent;
    }

    public ISimpleValue addSimpleValue(URI dataType, Object data) throws IdASException, InvalidTypeException {
        if (this.type == null) {
            throw new IdASException("Parameter \"type\" is null.");
        }
        this.initValues();
        if (this.isComplex) {
            throw new IdASException("Could not add simple value. Attribute is complex.");
        }
        SimpleValue sv = new SimpleValue(this.context, this, dataType, data);
        this.values.add(sv);
        this.isSimple = true;
        this.context.registerChangedObject(sv);
        return sv;
    }

    public IValue addValue(URI dataType) throws IdASException, InvalidTypeException {
        throw new IdASException("Could not create value. This context provider does not support schema.");
    }

    public IValue addValue(IValue copyFrom) throws IdASException {
        if (copyFrom == null) {
            return null;
        }
        if (copyFrom.isSimple()) {
            ISimpleValue sv = (ISimpleValue)copyFrom;
            this.addSimpleValue(sv.getType(), sv.getData());
            return sv;
        }
        IEntity e = (IEntity)copyFrom;
        if (e.getEntityID() == null || this.context != e.getContext()) {
            IEntity newEntity = this.addComplexValue(e.getType());
            Iterator attrs = e.getAttributes();
            while (attrs.hasNext()) {
                IAttribute attr = (IAttribute)attrs.next();
                newEntity.addAttribute(attr);
            }
            return newEntity;
        }
        this.initValues();
        IEntityReference erf = new IEntityReference(this, (Entity)e, this.context);
        this.context.registerChangedObject(erf);
        this.values.add(erf);
        return e;
    }

    public IAttributeModel getModel() throws IdASException {
        return null;
    }

    public URI getType() throws IdASException {
        return this.type;
    }

    public Iterator<IValue> getValues() throws IdASException {
        this.initValues();
        ArrayList<Entity> vals = new ArrayList<Entity>();
        for (IStatefulObject val : this.values) {
            if ("PRE_DELETED_NEW_OBJ".equals(val.getState()) || "PRE_DELETED_STORED_OBJ".equals(val.getState())) continue;
            if (val instanceof IEntityReference) {
                IEntityReference er = (IEntityReference)val;
                Entity ent = er.getValue();
                vals.add(ent);
                continue;
            }
            vals.add((Entity)((IValue)val));
        }
        return vals.iterator();
    }

    public Iterator<IValue> getValues(IExtension[] extensions) throws IdASException {
        return this.getValues();
    }

    public boolean isSingleValued() throws IdASException {
        return false;
    }

    public void remove() throws IdASException {
        this.initValues();
        for (IStatefulObject val : this.values) {
            if (val instanceof ISimpleValue) {
                ((ISimpleValue)val).remove();
                continue;
            }
            if (!(val instanceof IEntityReference)) continue;
            IEntityReference eref = (IEntityReference)val;
            eref.markDeleted();
            Entity ent = eref.getValue();
            if (ent.getEntityID() != null) continue;
            ent.remove();
        }
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public Iterator<IAttribute> getAttributes() throws IdASException {
        throw new NotImplementedException();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        throw new NotImplementedException();
    }

    public void removeAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        throw new NotImplementedException();
    }

    public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        throw new NotImplementedException();
    }

    void removeDeletedValue(IStatefulObject value) {
        this.values.remove(value);
    }

    public IEntity addComplexValue(String entityID) throws IdASException, InvalidTypeException {
        IEntity ref = this.context.getEntity(entityID);
        if (ref == null) {
            ref = this.context.createEntity(null, entityID);
        }
        this.addValue((IValue)ref);
        return ref;
    }
}

