/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.ContextEvent;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAuthNAttributesMaterials;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContextListener;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityIDAssertion;
import org.eclipse.higgins.idas.api.IFilterEntityTypeAssertion;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidEntityIDException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.Notifier;
import org.eclipse.higgins.idas.api.UnhandledExtensionException;
import org.eclipse.higgins.idas.api.model.IContextModel;
import org.eclipse.higgins.idas.cp.rdf2.IJenaContext;
import org.eclipse.higgins.idas.cp.rdf2.ISharedContext;
import org.eclipse.higgins.idas.cp.rdf2.IStatefulObject;
import org.eclipse.higgins.idas.cp.rdf2.impl.Entity;
import org.eclipse.higgins.idas.cp.rdf2.impl.EntityIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context
implements IJenaContext,
Notifier {
    private static Log log = LogFactory.getLog(Context.class);
    protected String ns;
    protected String contextId;
    protected ISharedContext sharedContext;
    private Vector<IStatefulObject> changedObjects = new Vector();
    private Hashtable<String, Entity> sessionEntityMap = new Hashtable();
    private IAuthNMaterials previousCredentials;
    private IExtension[] previousExtensions;
    private IAuthNMaterials identity;
    private ArrayList<IContextListener> listeners = new ArrayList();
    private ContextEvent contextUpdatedEvent = new ContextEvent(this, "CONTEXT_UPDATED");

    public Context(String contextId, ISharedContext sharedContext) {
        this.contextId = contextId;
        this.sharedContext = sharedContext;
    }

    @Override
    public String getNS() {
        return this.ns;
    }

    @Override
    public void registerChangedObject(IStatefulObject obj) {
        if (!this.changedObjects.contains(obj)) {
            this.changedObjects.add(obj);
        }
    }

    @Override
    public void unregisterChangedObject(IStatefulObject obj) {
        if (this.changedObjects.contains(obj)) {
            this.changedObjects.remove(obj);
        }
    }

    protected Entity getSessionEntity(String entityID) throws IdASException, EntityExistsException {
        if (entityID == null) {
            return null;
        }
        if (this.sessionEntityMap.containsKey(entityID)) {
            return this.sessionEntityMap.get(entityID);
        }
        return null;
    }

    private void ensureEntityNotExist(String entityID) throws IdASException, EntityExistsException {
        if (entityID == null) {
            return;
        }
        Entity en = this.getSessionEntity(entityID);
        if (en != null) {
            throw new EntityExistsException("Entity with such id already exists.");
        }
        Resource res = this.sharedContext.getEntityResource(entityID);
        if (res != null) {
            throw new EntityExistsException("Entity with such id already exists.");
        }
    }

    private void ensureContextOpen() throws ContextNotOpenException {
        if (this.identity == null) {
            throw new ContextNotOpenException();
        }
    }

    protected IEntity createEntity(URI type, String id) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
        this.ensureContextOpen();
        URI idURI = null;
        if (id == null) {
            id = UUIDGenerator.getUUID();
        }
        try {
            idURI = new URI(id);
        }
        catch (URISyntaxException e) {
            log.error((Object)e, (Throwable)e);
            throw new InvalidEntityIDException((Throwable)e);
        }
        this.ensureEntityNotExist(id);
        Entity entity = new Entity(this, type, idURI);
        this.registerSessionEntity(entity);
        this.registerChangedObject(entity);
        return entity;
    }

    public IEntity addEntity(URI type, String id) throws IdASException, InvalidTypeException, InvalidEntityIDException, EntityExistsException {
        if (type == null) {
            type = defaultEntityType;
        }
        return this.createEntity(type, id);
    }

    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null");
        }
        String newEntityId = copyFrom.getEntityID();
        try {
            this.ensureEntityNotExist(newEntityId);
        }
        catch (EntityExistsException e) {
            newEntityId = UUIDGenerator.getUUID();
        }
        Entity newEntity = (Entity)this.addEntity(copyFrom.getType(), newEntityId);
        Iterator attrs = copyFrom.getAttributes();
        while (attrs.hasNext()) {
            IAttribute attr = (IAttribute)attrs.next();
            newEntity.addAttribute(attr);
        }
        return newEntity;
    }

    public void applyUpdates() throws IdASException {
        this.ensureContextOpen();
        this.sharedContext.saveChanges(this.changedObjects);
        if (this.changedObjects.size() > 0) {
            this.notifyListeners(this.contextUpdatedEvent);
        }
        this.commitChangedObjectsState();
        this.changedObjects.clear();
    }

    public void cancelUpdates() throws IdASException {
        this.ensureContextOpen();
        this.rollbackUpdatedObjects();
        this.rollbackChangedObjectsState();
        this.changedObjects.clear();
    }

    public void close() throws IdASException {
        this.ensureContextOpen();
        this.cancelUpdates();
        this.sessionEntityMap.clear();
        this.sharedContext.close(this);
        this.identity = null;
    }

    @Override
    public ISharedContext getSharedContext() throws IdASException {
        this.ensureContextOpen();
        return this.sharedContext;
    }

    private void commitChangedObjectsState() throws IdASException {
        for (IStatefulObject obj : this.changedObjects) {
            obj.commitState();
        }
    }

    private void rollbackChangedObjectsState() throws IdASException {
        for (IStatefulObject obj : this.changedObjects) {
            obj.rollbackState();
        }
    }

    private void rollbackUpdatedObjects() throws IdASException {
        for (IStatefulObject obj : this.changedObjects) {
            obj.cancelUpdates();
        }
    }

    public String exportData(String filter, String representationFormat) throws IdASException {
        return null;
    }

    public URI getContextID() throws IdASException {
        return URI.create(this.contextId);
    }

    public Iterator<IEntity> getEntities(String query) throws IdASException {
        this.ensureContextOpen();
        if (query == null || query.trim().length() == 0) {
            ResIterator itr = this.sharedContext.getAllEntityResources();
            return new EntityIterator(this, itr, true);
        }
        return this.getEntitiesByQuery(query);
    }

    protected void registerSessionEntity(Entity entity) {
        String entId = null;
        try {
            entId = entity.getEntityID();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
        }
        if (entId != null) {
            this.sessionEntityMap.put(entId, entity);
        }
    }

    protected void unregisterSessionEntity(Entity entity) {
        String entId = null;
        try {
            entId = entity.getEntityID();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
        }
        if (entId != null) {
            this.sessionEntityMap.remove(entId);
        }
    }

    private Iterator<IEntity> getEntitiesByQuery(String query) throws IdASException {
        ArrayList<Entity> al = new ArrayList<Entity>();
        List<Resource> resurces = this.sharedContext.queryEntityResources(query);
        for (Resource res : resurces) {
            Entity entity = new Entity(this, res);
            this.registerSessionEntity(entity);
            al.add(entity);
        }
        return al.iterator();
    }

    public IEntity getEntity(String entityID) throws IdASException {
        this.ensureContextOpen();
        Entity en = this.getSessionEntity(entityID);
        if (en != null) {
            return en;
        }
        Resource res = this.sharedContext.getEntityResource(entityID);
        if (res != null) {
            Entity ent = new Entity(this, res);
            this.registerSessionEntity(ent);
            return ent;
        }
        return null;
    }

    public void importData(String filter, String representationFormat) throws IdASException {
        throw new NotImplementedException();
    }

    public boolean isOpen(Object identity) throws IdASException {
        if (identity == null) {
            return this.identity != null;
        }
        return identity.equals(this.identity);
    }

    public String open(IAuthNMaterials authentication, IExtension[] extensions) throws IdASException, ContextOpenException {
        if (this.isOpen(null)) {
            throw new ContextOpenException();
        }
        if (extensions != null) {
            for (int index = 0; index < extensions.length; ++index) {
                if (!extensions[index].failIfUnsupported()) continue;
                throw new UnhandledExtensionException(extensions[index].getClass().getName() + " not supported");
            }
        }
        this.sharedContext.open(this);
        this.previousExtensions = extensions;
        this.identity = this.previousCredentials = authentication;
        return null;
    }

    public String open(IAuthNMaterials authentication) throws IdASException, ContextOpenException {
        return this.open(authentication, null);
    }

    public void reopen() throws IdASException, AuthenticationException {
        if (this.previousCredentials == null) {
            throw new AuthenticationException("Previous authentication materials unavailable");
        }
        this.open(this.previousCredentials, this.previousExtensions);
    }

    public void setComponentSetting(String key, Object value, boolean failUnsupported) throws IdASException {
    }

    public void setComponentSetting(String key, Object value) throws IdASException {
    }

    public boolean verifyEntityAttributes(String entityID, Iterator attributes) throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public Iterator<IAttribute> getAttributes() throws IdASException {
        throw new NotImplementedException();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        throw new NotImplementedException();
    }

    public void removeAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        throw new NotImplementedException();
    }

    public IContextModel getContextModel() throws IdASException {
        return null;
    }

    public Iterator<IEntity> getEntities(String query, Iterator attrSelectionList) throws IdASException {
        return this.getEntities(query);
    }

    public Iterator<IEntity> getEntities(String query, Iterator attrSelectionList, IExtension[] extensions) throws IdASException {
        return this.getEntities(query);
    }

    public IEntity getEntity(String entityID, Iterator attrSelectionList) throws IdASException {
        return this.getEntity(entityID);
    }

    public String getSchema() throws IdASException {
        return null;
    }

    public void setSchema(String schema) throws IdASException {
        throw new IdASException("This context provider does not support schema.");
    }

    public IAttribute buildAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public IFilterAttributeAssertion buildAttributeAssertion() throws IdASException {
        throw new NotImplementedException();
    }

    public IAuthNAttributesMaterials buildAuthNAttributesMaterials() throws IdASException {
        throw new NotImplementedException();
    }

    public IEntity buildComplexAttrValue(URI dataType) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IFilterEntityIDAssertion buildEntityIDAssertion() throws IdASException {
        throw new NotImplementedException();
    }

    public IFilterEntityTypeAssertion buildEntityTypeAssertion() throws IdASException {
        throw new NotImplementedException();
    }

    public IFilter buildFilter() throws IdASException {
        throw new NotImplementedException();
    }

    public ISimpleValue buildSimpleAttrValue(URI dataType, Object value) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        throw new NotImplementedException();
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        throw new NotImplementedException();
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList, IExtension[] extensions) throws IdASException {
        throw new NotImplementedException();
    }

    public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
        throw new NotImplementedException();
    }

    @Override
    public void registerListener(IContextListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(IContextListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(ContextEvent event) {
        for (IContextListener listener : this.listeners) {
            try {
                listener.actionPerformed(event);
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }
}

