/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.cp.rdf2.impl.Attribute;
import org.eclipse.higgins.idas.cp.rdf2.impl.Context;
import org.eclipse.higgins.idas.cp.rdf2.impl.StatefulObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
extends StatefulObject
implements IEntity {
    private static Log log = LogFactory.getLog(Entity.class);
    private static final String RDF_TYPE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#type";
    private Context context = null;
    private URI type = null;
    private URI id = null;
    private Resource subject = null;
    private HashMap<URI, Attribute> attributes;

    public Entity(Context context, Resource subject) throws IdASException {
        RDFNode typeNode;
        this.subject = subject;
        this.context = context;
        String uri = subject.getURI();
        try {
            this.id = uri != null ? new URI(uri) : null;
        }
        catch (URISyntaxException e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
        Property typeProp = context.getSharedContext().getProperty(RDF_TYPE);
        Statement st = subject.getProperty(typeProp);
        if (st != null && (typeNode = st.getObject()).isResource()) {
            Resource typeRes = (Resource)typeNode.as(Resource.class);
            try {
                this.type = new URI(typeRes.getURI());
            }
            catch (URISyntaxException e) {
                log.error((Object)e, (Throwable)e);
                throw new IdASException((Throwable)e);
            }
        }
        this.setState("STORED_OBJ");
        this.context.registerSessionEntity(this);
    }

    public Entity(Context context, URI type, URI id) throws IdASException {
        this.context = context;
        this.type = type;
        this.id = id;
        this.attributes = new HashMap();
    }

    public IContext getContext() throws IdASException {
        return this.context;
    }

    public String getEntityID() throws IdASException {
        return this.id != null ? this.id.toString() : null;
    }

    public IEntityModel getModel() {
        return null;
    }

    public URI getType() throws IdASException {
        return this.type;
    }

    public boolean isSimple() throws IdASException {
        return false;
    }

    public void remove() throws IdASException {
        Iterator<IAttribute> attrs = this.getAttributes();
        while (attrs.hasNext()) {
            Attribute attr = (Attribute)attrs.next();
            attr.remove();
        }
        this.markDeleted();
        this.context.registerChangedObject(this);
    }

    public Attribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return this.getAttribute(attrID);
    }

    public Attribute addAttribute(IAttribute copyFrom) throws IdASException {
        if (copyFrom == null) {
            throw new IdASException("Parameter \"copyFrom\" is null.");
        }
        if (this.isProxy()) {
            return null;
        }
        Attribute newAttr = this.getAttribute(copyFrom.getType());
        Iterator itrVal = copyFrom.getValues();
        while (itrVal.hasNext()) {
            IValue value = (IValue)itrVal.next();
            newAttr.addValue(value);
        }
        return newAttr;
    }

    public Attribute getAttribute(URI type) throws IdASException {
        if (type == null) {
            throw new IdASException("Parameter \"attrType\" is null.");
        }
        if (this.isProxy()) {
            return null;
        }
        if (this.attributes == null) {
            this.initAttributes();
        }
        if (this.attributes.containsKey(type)) {
            return this.attributes.get(type);
        }
        return this.initAttribute(type);
    }

    private synchronized Attribute initAttribute(URI type) throws IdASException {
        if (this.attributes == null) {
            this.initAttributes();
        }
        if (this.attributes.containsKey(type)) {
            return this.attributes.get(type);
        }
        Attribute attr = new Attribute(this.context, this, type);
        this.attributes.put(type, attr);
        return attr;
    }

    private synchronized void initAttributes() throws IdASException {
        if (this.attributes == null) {
            if (this.subject == null) {
                throw new IdASException("Can not init attributes, subject of entity is null.");
            }
            HashMap<URI, Attribute> tmpAttr = new HashMap<URI, Attribute>();
            HashSet<String> uris = new HashSet<String>();
            StmtIterator itr = this.subject.listProperties();
            while (itr.hasNext()) {
                URI type;
                Statement st = (Statement)itr.next();
                String typeStr = st.getPredicate().getURI();
                if (RDF_TYPE.equals(typeStr) || !uris.add(typeStr)) continue;
                try {
                    type = new URI(typeStr);
                }
                catch (URISyntaxException e) {
                    log.error((Object)e, (Throwable)e);
                    throw new IdASException((Throwable)e);
                }
                Attribute attr = new Attribute(this.context, this, type);
                tmpAttr.put(type, attr);
            }
            this.attributes = tmpAttr;
        }
    }

    public Iterator<IAttribute> getAttributes() throws IdASException {
        if (this.isProxy()) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.attributes == null) {
            this.initAttributes();
        }
        ArrayList<Attribute> al = new ArrayList<Attribute>();
        al.addAll(this.attributes.values());
        return al.iterator();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        throw new NotSingleValuedAttributeException("This context provider does not support single valued attributes because does not use schema(model).");
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this.ensureNotProxy();
        Attribute atr = this.getAttribute(attrID);
        if (atr != null) {
            atr.remove();
        }
    }

    public Resource getSubject() {
        return this.subject;
    }

    private void ensureNotProxy() throws IdASException {
        if (this.isProxy()) {
            throw new IdASException("This is a proxy object.");
        }
    }

    private void ensureIsNotValue(Model model) throws IdASException {
        StmtIterator itr = model.listStatements(null, null, (RDFNode)this.subject);
        if (itr.hasNext()) {
            throw new IdASException("Could not remove an entity, should be removed from attributes before.");
        }
    }

    @Override
    public void saveUpdates(Model model) throws IdASException {
        if ("NEW_OBJ".equals(this.getState())) {
            String newId;
            String string = newId = this.id != null ? this.id.toString() : null;
            if (this.type != null) {
                Resource typeResource = model.getResource(this.type.toString());
                this.subject = model.createResource(newId, typeResource);
            } else {
                this.subject = model.getResource(newId);
            }
        } else if ("PRE_DELETED_STORED_OBJ".equals(this.getState())) {
            this.ensureIsNotValue(model);
            StmtIterator itr = model.listStatements(this.subject, null, (RDFNode)null);
            model.remove(itr);
        }
    }

    @Override
    public void commitState() {
        super.commitState();
        if ("PRE_DELETED_NEW_OBJ".equals(this.getState()) || "PRE_DELETED_STORED_OBJ".equals(this.getState()) || "DELETED_OBJ".equals(this.getState())) {
            this.context.unregisterSessionEntity(this);
        }
    }

    public IValueModel getValueModel() {
        return null;
    }

    public boolean isProxy() throws IdASException {
        return this.getType() == null;
    }

    @Override
    public void rollbackState() {
        super.rollbackState();
        if ("PRE_DELETED_NEW_OBJ".equals(this.getState()) || "NEW_OBJ".equals(this.getState())) {
            this.context.unregisterSessionEntity(this);
        }
    }

    @Override
    public void cancelUpdates() throws IdASException {
    }

    public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
        Attribute attr = this.getAttribute(attrType);
        return attr.addComplexValue(entityId);
    }

    public void removeAttributeValue(URI attrType, Object value) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        throw new NotImplementedException();
    }
}

