/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf2.impl.Context;
import org.eclipse.higgins.idas.cp.rdf2.impl.Entity;

public class EntityIterator
implements Iterator {
    private static Log log = LogFactory.getLog(EntityIterator.class);
    private boolean ignoreBlankEntity;
    private ResIterator resources = null;
    private Context context;
    private Entity currEntity = null;

    public EntityIterator(Context context, ResIterator resources, boolean ignoreBlankEntity) throws IdASException {
        this.context = context;
        this.resources = resources;
        this.ignoreBlankEntity = ignoreBlankEntity;
        this.initCurrentEntity();
    }

    private void initCurrentEntity() throws IdASException {
        this.currEntity = null;
        while (this.resources.hasNext() && this.currEntity == null) {
            Resource res = this.resources.nextResource();
            if (!res.isURIResource() && this.ignoreBlankEntity) continue;
            this.currEntity = new Entity(this.context, res);
            this.context.registerSessionEntity(this.currEntity);
        }
    }

    public boolean hasNext() {
        return this.currEntity != null;
    }

    public Entity next() {
        if (this.currEntity == null) {
            throw new NoSuchElementException();
        }
        Entity tmp = this.currEntity;
        try {
            this.initCurrentEntity();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
        return tmp;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

