/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf2.impl.Attribute;
import org.eclipse.higgins.idas.cp.rdf2.impl.Context;
import org.eclipse.higgins.idas.cp.rdf2.impl.Entity;
import org.eclipse.higgins.idas.cp.rdf2.impl.StatefulObject;

public class IEntityReference
extends StatefulObject {
    private Attribute owner;
    private Entity value;
    private Context context;

    public IEntityReference(Attribute owner, Entity value, Context context) {
        this.owner = owner;
        this.value = value;
        this.context = context;
    }

    public Entity getValue() {
        return this.value;
    }

    public Attribute getOwner() {
        return this.owner;
    }

    public void saveUpdates(Model model) throws IdASException {
        if ("NEW_OBJ".equals(this.getState())) {
            Statement st;
            String attrType = this.owner.getType().toString();
            Property attrProp = this.context.getSharedContext().getProperty(attrType);
            Resource ownerSubject = this.owner.getOwner().getSubject();
            Resource valueSubject = this.value.getSubject();
            if (valueSubject != null) {
                st = model.createStatement(ownerSubject, attrProp, (RDFNode)valueSubject);
            } else {
                String valueId = this.value.getEntityID();
                st = model.createStatement(ownerSubject, attrProp, valueId);
            }
            model.add(st);
        } else if ("PRE_DELETED_STORED_OBJ".equals(this.getState())) {
            String attrType = this.owner.getType().toString();
            Property attrProp = this.context.getSharedContext().getProperty(attrType);
            Resource ownerSubject = this.owner.getOwner().getSubject();
            Resource valueSubject = this.value.getSubject();
            model.remove(ownerSubject, attrProp, (RDFNode)valueSubject);
        }
    }

    public void commitState() {
        super.commitState();
        if (this.owner != null && ("PRE_DELETED_NEW_OBJ".equals(this.getState()) || "PRE_DELETED_STORED_OBJ".equals(this.getState()) || "DELETED_OBJ".equals(this.getState()))) {
            this.owner.removeDeletedValue(this);
        }
    }

    public void rollbackState() {
        super.rollbackState();
        if ("PRE_DELETED_NEW_OBJ".equals(this.getState()) || "NEW_OBJ".equals(this.getState())) {
            this.owner.removeDeletedValue(this);
        }
    }

    public void cancelUpdates() throws IdASException {
    }
}

