/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf2.impl.Context;
import org.eclipse.higgins.idas.cp.rdf2.impl.SharedJDBCContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCContextFactory
implements IContextFactory {
    private static Log log = LogFactory.getLog(JDBCContextFactory.class);
    private ISettingDescriptor contextFactoryDescriptor = null;
    private List<String> contextTypesList = null;
    private HashMap<String, SharedJDBCContext> sharedContexts = new HashMap();

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        if (mapComponentSettings != null) {
            this.contextTypesList = (List)mapComponentSettings.get("ContextTypes");
        }
        this.contextFactoryDescriptor = componentDescriptor;
    }

    public IContext createContext(IContextId contextID) throws IdASException {
        if (contextID == null) {
            throw new IdASException("Parameter \"contextID\" is null.");
        }
        Map config = contextID.getConfiguration();
        try {
            String contextId = (String)config.get("context.uri");
            SharedJDBCContext sharedContext = this.getSharedContext(contextID, contextId);
            return new Context(contextId, sharedContext);
        }
        catch (IdASException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
    }

    public ISettingDescriptor getComponentDescriptor() {
        return this.contextFactoryDescriptor;
    }

    public List<String> getTypes() throws IdASException {
        return this.contextTypesList;
    }

    public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException {
        return null;
    }

    public Iterator<URI> getContexts(String filter) throws IdASException {
        return null;
    }

    public String getName() throws IdASException {
        return null;
    }

    public String getPolicy() throws IdASException {
        return null;
    }

    public void setPolicy(String policy) throws IdASException {
    }

    private synchronized SharedJDBCContext getSharedContext(IContextId contextID, String contextId) throws IdASException {
        if (this.sharedContexts.containsKey(contextId)) {
            return this.sharedContexts.get(contextId);
        }
        SharedJDBCContext sfc = new SharedJDBCContext(contextID.getConfiguration());
        this.sharedContexts.put(contextId, sfc);
        return sfc;
    }
}

