/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf2.IJenaContext;
import org.eclipse.higgins.idas.cp.rdf2.ISharedContext;
import org.eclipse.higgins.idas.cp.rdf2.IStatefulObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SharedContext
implements ISharedContext {
    private static Log log = LogFactory.getLog(SharedContext.class);
    private Hashtable<String, Property> properties = new Hashtable();
    private Hashtable<String, Resource> resources = new Hashtable();
    protected Vector<Object> openContexts = new Vector();
    protected Model model;
    protected String baseNS;

    @Override
    public Resource getEntityResource(String entityID) {
        Resource res = this.model.getResource(entityID);
        if (this.model.containsResource((RDFNode)res)) {
            return res;
        }
        return null;
    }

    public ArrayList<Resource> queryEntityResources(String query) throws IdASException {
        ArrayList<Resource> al = new ArrayList<Resource>();
        QueryExecution qexec = null;
        try {
            Query q = QueryFactory.create((String)query);
            qexec = QueryExecutionFactory.create((Query)q, (Model)this.model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                Resource res = soln.getResource(soln.varNames().next().toString());
                al.add(res);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
        finally {
            if (qexec != null) {
                qexec.close();
            }
        }
        return al;
    }

    @Override
    public ResIterator getAllEntityResources() throws IdASException {
        return this.model.listSubjects();
    }

    @Override
    public Property getProperty(String uri) throws IdASException {
        if (this.properties.containsKey(uri)) {
            return this.properties.get(uri);
        }
        Property prop = this.model.getProperty(uri);
        this.properties.put(uri, prop);
        return prop;
    }

    @Override
    public Resource getResource(String uri) throws IdASException {
        if (this.resources.containsKey(uri)) {
            return this.resources.get(uri);
        }
        Resource res = this.model.getResource(uri);
        this.resources.put(uri, res);
        return res;
    }

    @Override
    public synchronized void saveChanges(List<IStatefulObject> changedObjects) throws IdASException {
        try {
            for (IStatefulObject obj : changedObjects) {
                obj.saveUpdates(this.model);
            }
            this.saveModel();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            try {
                this.initModel();
            }
            catch (Exception e1) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    protected abstract void saveModel() throws IdASException;

    protected abstract void initModel() throws IdASException;

    protected abstract void closeModel() throws IdASException;

    @Override
    public void close(IJenaContext context) throws IdASException {
        this.openContexts.remove(context);
        if (this.openContexts.size() == 0) {
            this.closeModel();
        }
    }

    @Override
    public synchronized void open(IJenaContext context) throws IdASException {
        if (this.openContexts.size() == 0) {
            this.initModel();
        }
        this.openContexts.add(context);
    }
}

