/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf2.impl.SharedContext;

public class SharedFileContext
extends SharedContext {
    private static Log log = LogFactory.getLog(SharedFileContext.class);
    protected File contextFile = null;

    public SharedFileContext(String fileModel, String baseNS) throws IdASException {
        this.contextFile = new File(fileModel);
        this.baseNS = baseNS;
    }

    private void loadModel() throws IdASException {
        FileInputStream fis = null;
        try {
            this.model = ModelFactory.createDefaultModel();
            fis = new FileInputStream(this.contextFile);
            this.model.read((InputStream)fis, this.baseNS);
        }
        catch (FileNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void createModel() throws IdASException {
        this.model = ModelFactory.createDefaultModel();
    }

    protected void saveModel() throws IdASException {
        FileOutputStream fos = null;
        RDFWriter w = this.model.getWriter("RDF/XML-ABBREV");
        w.setProperty("showXmlDeclaration", (Object)"true");
        w.setProperty("xmlbase", (Object)this.baseNS);
        w.setProperty("allowBadURIs", (Object)"true");
        w.setProperty("relativeURIs", (Object)"same-document,relative");
        try {
            File dir = this.contextFile.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            File tmpFile = File.createTempFile("tmp", ".$");
            fos = new FileOutputStream(tmpFile);
            w.write(this.model, (OutputStream)fos, this.baseNS);
            fos.flush();
            fos.close();
            if (this.contextFile.exists() && !this.contextFile.delete()) {
                throw new IdASException("Couldn't save context");
            }
            tmpFile.renameTo(this.contextFile);
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
    }

    protected void initModel() throws IdASException {
        try {
            if (this.contextFile.exists()) {
                this.loadModel();
            } else {
                this.createModel();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
    }

    protected void closeModel() throws IdASException {
        try {
            this.model.close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
    }
}

