/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.db.DBConnection;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.rdf2.impl.SharedContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedJDBCContext
extends SharedContext {
    private static Log log = LogFactory.getLog(SharedJDBCContext.class);
    private String dbURL;
    private String dbUser;
    private String dbPassword;
    private String dbEngineName;
    private String dbClass;
    protected IDBConnection conn;
    protected ModelMaker maker;

    public SharedJDBCContext(Map<?, ?> config) throws IdASException {
        this.dbURL = (String)config.get("db.url");
        this.dbUser = (String)config.get("db.user");
        this.dbPassword = (String)config.get("db.password");
        this.dbEngineName = (String)config.get("db.engine");
        this.dbClass = (String)config.get("db.driver");
        this.baseNS = (String)config.get("context.uri");
    }

    @Override
    protected void closeModel() throws IdASException {
        try {
            this.model.close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
        try {
            this.maker.close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
    }

    @Override
    protected void saveModel() throws IdASException {
    }

    @Override
    protected void initModel() throws IdASException {
        try {
            Class.forName(this.dbClass);
            this.conn = new DBConnection(this.dbURL, this.dbUser, this.dbPassword, this.dbEngineName);
            this.maker = ModelFactory.createModelRDBMaker((IDBConnection)this.conn);
            this.model = this.maker.hasModel(this.baseNS) ? this.maker.openModel(this.baseNS) : this.maker.createModel(this.baseNS);
        }
        catch (Exception e) {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                throw new IdASException((Throwable)ex);
            }
            log.error((Object)e, (Throwable)e);
            throw new IdASException((Throwable)e);
        }
    }
}

