/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.cp.rdf2.impl.Attribute;
import org.eclipse.higgins.idas.cp.rdf2.impl.Context;
import org.eclipse.higgins.idas.cp.rdf2.impl.StatefulObject;
import org.eclipse.higgins.idas.cp.rdf2.util.XMLValueHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValue
extends StatefulObject
implements ISimpleValue {
    private static Log log = LogFactory.getLog(SimpleValue.class);
    private Context context;
    private Attribute owner;
    private Literal literal;
    private Object previousData;
    private Object data;
    private XMLValueHelper valueHelper;
    private URI type;

    public SimpleValue(Context context, Attribute owner, Literal literal) throws IdASException {
        if (literal == null) {
            throw new IdASException("Parameter \"literal\" is null.");
        }
        RDFDatatype rdfType = literal.getDatatype();
        if (rdfType != null) {
            try {
                this.type = new URI(rdfType.getURI());
            }
            catch (URISyntaxException e) {
                log.error((Object)e, (Throwable)e);
                throw new IdASException((Throwable)e);
            }
        } else {
            this.type = ITypedValue.STRING_TYPE_URI;
        }
        this.valueHelper = XMLValueHelper.getInstance(this.type.toString());
        this.previousData = this.data = this.valueHelper.toValueForm(literal);
        this.context = context;
        this.owner = owner;
        this.literal = literal;
        this.setState("STORED_OBJ");
    }

    public SimpleValue(Context context, Attribute owner, URI type, Object data) throws IdASException {
        if (type == null) {
            throw new IdASException("Parameter \"type\" is null.");
        }
        XMLValueHelper tmpValueHelper = XMLValueHelper.getInstance(type.toString());
        if (data != null && !tmpValueHelper.isValidValue(data)) {
            throw new IdASException("Not valid data " + data.getClass() + " for simple value with type " + type.toString());
        }
        this.valueHelper = tmpValueHelper;
        this.context = context;
        this.owner = owner;
        this.type = type;
        this.data = data;
    }

    public ISimpleValueModel getModel() {
        return null;
    }

    public String getCanonical() throws IdASException {
        return this.getLexical();
    }

    public Object getData() throws IdASException {
        return this.data;
    }

    public String getLexical() throws IdASException {
        return this.data != null ? this.valueHelper.toLexicalForm(this.data) : null;
    }

    public void setData(Object data) throws IdASException {
        if (data != null && !this.valueHelper.isValidValue(data)) {
            throw new IdASException("Not valid data " + data.getClass() + " for simple value with type " + this.type.toString());
        }
        this.data = data;
        this.markChanged();
        this.context.registerChangedObject(this);
    }

    public void remove() {
        this.context.registerChangedObject(this);
        this.markDeleted();
    }

    public URI getType() {
        return this.type;
    }

    public boolean isSimple() {
        return true;
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public Iterator<IAttribute> getAttributes() throws IdASException {
        throw new NotImplementedException();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        throw new NotImplementedException();
    }

    public void removeAttribute(URI attrID) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        throw new NotImplementedException();
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        throw new NotImplementedException();
    }

    @Override
    public void saveUpdates(Model model) throws IdASException {
        String attrType = this.owner.getType().toString();
        Property attrProp = this.context.getSharedContext().getProperty(attrType);
        Resource ownerSubject = this.owner.getOwner().getSubject();
        if ("NEW_OBJ".equals(this.getState())) {
            if (this.data != null) {
                String lexicalForm = this.valueHelper.toLexicalForm(this.data);
                this.literal = model.createTypedLiteral(lexicalForm, this.type.toString());
                Statement st = model.createStatement(ownerSubject, attrProp, (RDFNode)this.literal);
                model.add(st);
            }
            this.previousData = this.data;
        } else if ("CHANGED_OBJ".equals(this.getState())) {
            if (this.literal != null) {
                model.remove(ownerSubject, attrProp, (RDFNode)this.literal);
            }
            if (this.data != null) {
                String lexicalForm = this.valueHelper.toLexicalForm(this.data);
                this.literal = model.createTypedLiteral(lexicalForm, this.type.toString());
                Statement st = model.createStatement(ownerSubject, attrProp, (RDFNode)this.literal);
                model.add(st);
            }
            this.previousData = this.data;
        } else if ("PRE_DELETED_STORED_OBJ".equals(this.getState()) && this.literal != null) {
            model.remove(ownerSubject, attrProp, (RDFNode)this.literal);
        }
    }

    @Override
    public void commitState() {
        super.commitState();
        if (this.owner != null && ("PRE_DELETED_NEW_OBJ".equals(this.getState()) || "PRE_DELETED_STORED_OBJ".equals(this.getState()) || "DELETED_OBJ".equals(this.getState()))) {
            this.owner.removeDeletedValue(this);
        }
    }

    public IValueModel getValueModel() {
        return null;
    }

    @Override
    public void cancelUpdates() throws IdASException {
        if ("CHANGED_OBJ".equals(this.getState())) {
            this.data = this.previousData;
        }
    }

    @Override
    public void rollbackState() {
        super.rollbackState();
        if ("PRE_DELETED_NEW_OBJ".equals(this.getState()) || "NEW_OBJ".equals(this.getState())) {
            this.owner.removeDeletedValue(this);
        }
    }

    public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
        throw new NotImplementedException();
    }
}

