/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rdf2.util;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.rdf.model.Literal;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.model.IdASModelException;
import org.eclipse.higgins.idas.cp.rdf2.util.XMLDateConvertor;

public class XMLValueHelper {
    private static Log log = LogFactory.getLog(XMLValueHelper.class);
    protected String type = null;
    protected XSDDatatype xsdType = null;
    protected static Hashtable<String, XMLValueHelper> typesMap = new Hashtable();

    public static synchronized XMLValueHelper getInstance(String xmlType) throws IdASException {
        if (xmlType == null) {
            return null;
        }
        if (typesMap.contains(xmlType)) {
            return typesMap.get(xmlType);
        }
        XMLValueHelper valueModel = new XMLValueHelper(xmlType);
        typesMap.put(xmlType, valueModel);
        return valueModel;
    }

    protected XMLValueHelper(String xmlType) throws IdASException {
        this.initType(xmlType);
    }

    protected void initType(String typeUri) throws IdASException {
        try {
            this.xsdType = XMLValueHelper.findXSDDatatype(typeUri);
            if (this.xsdType == null) {
                throw new IdASModelException("Unsupported datatype " + typeUri);
            }
            this.type = typeUri;
        }
        catch (IdASException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IdASModelException("Invalid datatype " + typeUri, (Throwable)e);
        }
    }

    public static XSDDatatype findXSDDatatype(String typeUri) {
        if (typeUri == null) {
            return null;
        }
        RDFDatatype rdfType = TypeMapper.getInstance().getTypeByName(typeUri);
        if (rdfType == null) {
            log.warn((Object)("Couldn't find RDFDatatype by URI = " + typeUri));
            return null;
        }
        if (!(rdfType instanceof XSDDatatype)) {
            log.warn((Object)("URI " + typeUri + " is not xsd datatype"));
            return null;
        }
        return (XSDDatatype)rdfType;
    }

    public static boolean isSupported(String typeUri) {
        return XMLValueHelper.findXSDDatatype(typeUri) != null;
    }

    public String getType() {
        return this.type;
    }

    public boolean isValidValue(Object valueForm) {
        return this.xsdType.isValidValue(valueForm);
    }

    public boolean isValid(String lexicalForm) {
        return this.xsdType.isValid(lexicalForm);
    }

    public Object toValueForm(String lexicalForm) throws IdASModelException {
        if (lexicalForm == null) {
            return "";
        }
        try {
            return this.xsdType.parse(lexicalForm);
        }
        catch (Exception e) {
            throw new IdASModelException((Throwable)e);
        }
    }

    public Object toValueForm(Literal literal) throws IdASModelException {
        if (literal != null) {
            Object obj = this.parse(literal);
            return obj;
        }
        return null;
    }

    public String toLexicalForm(Object value) throws IdASModelException {
        if (value == null) {
            return null;
        }
        return this.unparseObj(value);
    }

    private String unparseObj(Object value) throws IdASModelException {
        try {
            if (value instanceof Date) {
                return XMLDateConvertor.format((Date)value);
            }
            if (value instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)value;
                byte[] data = bb.array();
                return Base64.encode((byte[])data);
            }
            return this.xsdType.unparse(value);
        }
        catch (Exception e) {
            throw new IdASModelException("Can not get lexical form for xml type " + this.type.toString() + ", object value " + value);
        }
    }

    private Object parse(Literal lt) throws IdASModelException {
        try {
            if (this.type.equals("http://www.w3.org/2001/XMLSchema#date") || this.type.equals("http://www.w3.org/2001/XMLSchema#dateTime") || this.type.equals("http://www.w3.org/2001/XMLSchema#time")) {
                return XMLDateConvertor.parse(lt.getString());
            }
            if (this.type.equals("http://www.w3.org/2001/XMLSchema#anyURI")) {
                try {
                    return new URI(lt.getString());
                }
                catch (Exception e) {
                    log.error((Object)e);
                    throw new IdASModelException((Throwable)e);
                }
            }
            if ("http://www.w3.org/2001/XMLSchema#base64Binary".equals(this.type) || "http://www.w3.org/2001/XMLSchema#byte".equals(this.type)) {
                byte[] data = Base64.decode((String)lt.getString());
                ByteBuffer bb = ByteBuffer.allocate(data.length);
                bb.put(data);
                return bb;
            }
            return lt.getValue();
        }
        catch (Exception e) {
            throw new IdASModelException((Throwable)e);
        }
    }
}

