/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rest.xml;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.audit.api.AuditException;
import org.eclipse.higgins.audit.api.AuditRecord;
import org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.rest.xml.RESTEntity;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.idas.spi.ValueNotification;
import org.eclipse.higgins.util.xml.DomFuncs;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RESTContext
extends BasicContext {
    private Log _log;
    private Log _auditLog;
    private AuditRecord _auditRecord;
    private IContextId _contextID;
    private HttpClient _httpClient;
    private URI _authSessionURI;
    private String _authEntityID;
    private String _sessionSecret;
    private DocumentBuilder _docBuilder;
    private Configuration _templateConfig;
    private Map _contextSettings;
    private String _contextURIs;
    private String _contextTypes;
    private static final String TEMPLATE_MAP_ENTITY_CHANGE_LIST = "EntityChangeList";
    private static final String TEMPLATE_MAP_ENTITY_ID = "EntityID";
    private static final String TEMPLATE_MAP_ENTITY_CHANGE_TYPE = "EntityChangeType";
    private static final String TEMPLATE_MAP_ENTITY_CHANGE_ADD = "EntityAdd";
    private static final String TEMPLATE_MAP_ENTITY_CHANGE_REMOVE = "EntityRemove";
    private static final String TEMPLATE_MAP_ENTITY_CHANGE_UPDATE = "EntityChange";
    private static final String TEMPLATE_MAP_ENTITY_TYPE = "EntityType";
    private static final String TEMPLATE_MAP_ENTITY_ATTR_LIST = "EntityAttributeList";
    private static final String TEMPLATE_MAP_ATTRIBUTE_CHANGE_TYPE = "AttributeChangeType";
    private static final String TEMPLATE_MAP_ATTRIBUTE_ADD = "AttributeAdd";
    private static final String TEMPLATE_MAP_ATTRIBUTE_REMOVE = "AttributeRemove";
    private static final String TEMPLATE_MAP_ATTRIBUTE_CHANGE = "AttributeChange";
    private static final String TEMPLATE_MAP_ATTRIBUTE_ID = "AttributeID";
    private static final String TEMPLATE_MAP_ATTRIBUTE_VALUES = "AttributeValues";
    private static final String TEMPLATE_MAP_VALUE_TYPE = "ValueType";
    private static final String TEMPLATE_MAP_SIMPLE_VALUE = "SimpleValue";
    private static final String TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE = "AttributeValueChangeType";
    private static final String TEMPLATE_MAP_ATTRIBUTE_VALUE_ATTRIBUTE_LIST = "AttributeValueAttributeList";
    private static final String TEMPLATE_MAP_ATTRIBUTE_VALUE_ADD = "AttributeValueAdd";
    private static final String TEMPLATE_MAP_ATTRIBUTE_VALUE_REMOVE = "AttributeValueRemove";
    private static final String TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE = "AttributeValueChange";
    static /* synthetic */ Class class$0;

    public RESTContext(IContextId contextID) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.rest.xml.RESTContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._auditLog = LogFactory.getLog((String)"higgins.audit.events");
        this._auditRecord = null;
        this._authEntityID = null;
        this._sessionSecret = null;
        this._contextURIs = "";
        this._contextTypes = "";
        this._contextID = contextID;
        this._authEntityID = null;
        URI[] contextURIs = this._contextID.getUris();
        int iLoop = 0;
        while (iLoop < contextURIs.length) {
            this._contextURIs = String.valueOf(this._contextURIs) + contextURIs[iLoop].toString() + ", ";
            ++iLoop;
        }
        String[] contextTypes = this._contextID.getTypes();
        iLoop = 0;
        while (iLoop < contextTypes.length) {
            this._contextTypes = String.valueOf(this._contextTypes) + contextTypes[iLoop] + ", ";
            ++iLoop;
        }
        this._contextSettings = this._contextID.getConfiguration();
        try {
            this._templateConfig = new Configuration();
            String strTemplateDir = (String)this._contextSettings.get("templateDir");
            if (strTemplateDir == null) {
                throw new IdASException("No template directory configured.");
            }
            File templateDir = new File(strTemplateDir);
            this._templateConfig.setDirectoryForTemplateLoading(templateDir);
            this._templateConfig.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
        String strAuditRecordClass = (String)this._contextSettings.get("AuditRecordClass");
        if (strAuditRecordClass != null) {
            try {
                this._auditRecord = (AuditRecord)ConfigurableComponentFactoryHelper.getInstanceFromClassName((String)strAuditRecordClass);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    public static void throwIdASException(HttpMethod meth) throws IdASException {
        Document doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(meth.getResponseBodyAsStream());
        }
        catch (ParserConfigurationException e) {
            throw new IdASException((Throwable)e);
        }
        catch (SAXException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
        doc.getDocumentElement();
        Exception e = DomFuncs.getException((Element)doc.getDocumentElement(), (String)"org.eclipse.higgins.idas.api.IdASException");
        if (e == null || !(e instanceof IdASException)) {
            throw new IdASException(RESTContext.httpMethFailure(meth));
        }
        throw (IdASException)e;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String open(Object identity) throws IdASException {
        if (this.isOpen(null)) {
            throw new ContextOpenException();
        }
        if (!(identity instanceof URI)) throw new NotImplementedException("Unsupported AuthN materials: " + identity.toString());
        try {
            this._httpClient = this._getHttpClient();
            this._authSessionURI = new URI(((URI)identity).getScheme(), null, ((URI)identity).getHost(), ((URI)identity).getPort(), ((URI)identity).getPath(), null, null);
            String query = ((URI)identity).getRawQuery();
            if (query != null) {
                int secretStart;
                int entityIDStart = query.indexOf("entity=");
                if (entityIDStart != -1) {
                    int entityIDEnd = query.indexOf("&", entityIDStart += "entity=".length());
                    if (entityIDEnd == -1) {
                        entityIDEnd = query.length();
                    }
                    char[] entityID = new char[entityIDEnd - entityIDStart];
                    query.getChars(entityIDStart, entityIDEnd, entityID, 0);
                    this._authEntityID = new String(entityID);
                }
                if ((secretStart = query.indexOf("secret=")) != -1) {
                    int secretEnd = query.indexOf("&", secretStart += "secret=".length());
                    if (secretEnd == -1) {
                        secretEnd = query.length();
                    }
                    char[] secret = new char[secretEnd - secretStart];
                    query.getChars(secretStart, secretEnd, secret, 0);
                    this._sessionSecret = new String(secret);
                }
            }
            if (this._authEntityID == null) {
                int httpCode;
                GetMethod meth = new GetMethod(String.valueOf(this.getEndpointURL()) + "/entityID");
                if (this.getSessionSecret() != null) {
                    meth.addRequestHeader("SessionSecret", this.getSessionSecret());
                }
                if ((httpCode = this._httpClient.executeMethod((HttpMethod)meth)) != 200) {
                    RESTContext.throwIdASException((HttpMethod)meth);
                }
                this._authEntityID = this._processEntityIDResponse((HttpMethod)meth);
            }
        }
        catch (URISyntaxException e) {
            throw new IdASException((Throwable)e);
        }
        catch (HttpException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
        this.setOpen(true);
        this._emitAuditRecord(0x1000007, 0, this._authEntityID, null, null);
        return this._authEntityID;
    }

    public void close() throws IdASException {
        super.close();
        this._emitAuditRecord(0x1000008, 0, this._authEntityID, null, null);
    }

    private String _processEntityIDResponse(HttpMethod meth) throws IdASException {
        Element content;
        Document doc = this._getResponseDoc(meth);
        Element root = doc.getDocumentElement();
        String entityID = null;
        if (!DomFuncs.isElementNode((Node)root, (String)"http://www.w3.org/2005/Atom", (String)"feed")) {
            throw new IdASException("Unexpected response, expected: feed");
        }
        Element entry = DomFuncs.getFirstChildElement((Node)root, (String)"http://www.w3.org/2005/Atom", (String)"entry");
        if (entry != null && (content = DomFuncs.getFirstChildElement((Node)entry, (String)"http://www.w3.org/2005/Atom", (String)"content")) != null) {
            entityID = DomFuncs.getNodeText((Node)content);
        }
        return entityID;
    }

    private Document _getResponseDoc(HttpMethod meth) throws IdASException {
        try {
            return this._getDocumentBuilder().parse(meth.getResponseBodyAsStream());
        }
        catch (SAXException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
    }

    private HttpClient _getHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.protocol.allow-circular-redirects", (Object)Boolean.FALSE);
        httpClient.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        httpClient.getParams().setSoTimeout(10001);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10001);
        return httpClient;
    }

    public IEntity getEntity(String entityID) throws IdASException {
        this._emitAuditRecord(0x1000005, 0, this._authEntityID, entityID, null);
        return new RESTEntity(this, this._httpClient, entityID);
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        if (filter == null) {
            this._getAllEntities();
        }
        return super.getEntities(filter);
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList) throws IdASException {
        if (filter == null) {
            this._getAllEntities();
        }
        return super.getEntities(filter, attrSelectionList);
    }

    public Iterator getEntities(IFilter filter, Iterator attrSelectionList, IExtension[] extensions) throws IdASException {
        if (filter == null) {
            this._getAllEntities();
        }
        return super.getEntities(filter, attrSelectionList, extensions);
    }

    private void _getAllEntities() throws IdASException {
        try {
            int httpCode;
            GetMethod meth = new GetMethod(String.valueOf(this.getEndpointURL()) + "/Context/");
            if (this.getSessionSecret() != null) {
                meth.addRequestHeader("SessionSecret", this.getSessionSecret());
            }
            if ((httpCode = this._httpClient.executeMethod((HttpMethod)meth)) != 200) {
                RESTContext.throwIdASException((HttpMethod)meth);
            }
            try {
                Document doc = this._getResponseDoc((HttpMethod)meth);
                Element contextElement = doc.getDocumentElement();
                Element entityElement = DomFuncs.getFirstChildElement((Node)contextElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"Entity");
                while (entityElement != null) {
                    RESTEntity entity = new RESTEntity(this, this._httpClient, entityElement);
                    if (entity.getEntityID() == null) {
                        throw new IdASException("No entityID found in entity returned by server");
                    }
                    this.addUnnotifiedEntity((IEntity)entity);
                    entityElement = DomFuncs.getNextSiblingElement((Node)entityElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"Entity");
                }
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
        catch (HttpException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
    }

    public String getEndpointURL() {
        return this._authSessionURI.toString();
    }

    public String getSessionSecret() {
        return this._sessionSecret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void applyUpdates() throws IdASException {
        Hashtable updateList = super.getUpdateList();
        try {
            try {
                ArrayList entityChangeList = new ArrayList();
                int iCount = 0;
                Iterator keyIter = updateList.keySet().iterator();
                while (true) {
                    if (!keyIter.hasNext()) {
                        HashMap contextChangeMap = new HashMap();
                        contextChangeMap.put(TEMPLATE_MAP_ENTITY_CHANGE_LIST, entityChangeList);
                        StringWriter strWriter = new StringWriter(1024);
                        Template template = this._templateConfig.getTemplate("PUT_ContextChangesRequest.fmt");
                        template.process(contextChangeMap, (Writer)strWriter);
                        PutMethod meth = new PutMethod(String.valueOf(this.getEndpointURL()) + "/Context");
                        if (this.getSessionSecret() != null) {
                            meth.addRequestHeader("SessionSecret", this.getSessionSecret());
                        }
                        String content = strWriter.toString();
                        StringRequestEntity requestEntity = new StringRequestEntity(content, "text/xml", "utf-8");
                        meth.setRequestEntity((RequestEntity)requestEntity);
                        int httpCode = this._httpClient.executeMethod((HttpMethod)meth);
                        if (httpCode == 200) break;
                        RESTContext.throwIdASException((HttpMethod)meth);
                    }
                    String entityID = (String)keyIter.next();
                    this._addEntityChange(entityChangeList, entityID, (Vector)updateList.get(entityID));
                    ++iCount;
                }
                this._log.debug((Object)(String.valueOf(iCount) + "entity" + (iCount == 1 ? " change " : " changes ") + "applied"));
            }
            catch (IdASException e) {
                throw e;
            }
            catch (HttpException e) {
                throw new IdASException((Throwable)e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            updateList.clear();
            throw throwable;
        }
        {
            Object var12_18 = null;
            updateList.clear();
            return;
        }
    }

    private void _addEntityChange(List changeList, String entityID, Vector entityNotifs) throws IdASException {
        EntityNotification[] aEntityNotifs = entityNotifs.toArray(new EntityNotification[entityNotifs.size()]);
        this._log.debug((Object)("Updating entry [" + entityID + "], " + aEntityNotifs[0].getAction()));
        HashMap<String, String> changeMap = null;
        int index = 0;
        while (index < aEntityNotifs.length) {
            changeMap = new HashMap<String, String>();
            changeMap.put(TEMPLATE_MAP_ENTITY_ID, entityID);
            String notifAction = aEntityNotifs[index].getAction();
            if (notifAction.equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD")) {
                changeMap.put(TEMPLATE_MAP_ENTITY_CHANGE_TYPE, TEMPLATE_MAP_ENTITY_CHANGE_ADD);
                this._addEntityToChangeMap(changeMap, aEntityNotifs, index);
                changeList.add(changeMap);
                break;
            }
            if (!notifAction.equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE")) {
                if (notifAction.equals("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY")) {
                    changeMap.put(TEMPLATE_MAP_ENTITY_CHANGE_TYPE, TEMPLATE_MAP_ENTITY_CHANGE_UPDATE);
                    this._addEntityUpdatesToChangeMap(changeMap, aEntityNotifs, index);
                    changeList.add(changeMap);
                    break;
                }
                throw new NotImplementedException(aEntityNotifs[index].getAction());
            }
            changeMap.put(TEMPLATE_MAP_ENTITY_CHANGE_TYPE, TEMPLATE_MAP_ENTITY_CHANGE_REMOVE);
            changeList.add(changeMap);
            ++index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _addEntityToChangeMap(Map changeMap, EntityNotification[] entityNotifs, int index) throws IdASException {
        IEntity entity = entityNotifs[index].getEntity();
        changeMap.put(TEMPLATE_MAP_ENTITY_TYPE, entity.getModel().getType().toString());
        ArrayList<Map> attrList = new ArrayList<Map>();
        int iLoop = index;
        while (iLoop < entityNotifs.length) {
            if (entityNotifs[iLoop].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY") == 0) {
                AttributeNotification attrNotif = entityNotifs[iLoop].getAttributeNotification();
                if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY") == 0) {
                    ValueNotification attrValNotif = attrNotif.getAttributeValueNotification();
                    if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD") != 0) {
                        throw new IdASException("Unallowed attribute value notification type during entity creation: " + attrValNotif.getAction());
                    }
                } else {
                    if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD") != 0) throw new IdASException("Unallowed attribute notification type during entity creation: " + attrNotif.getAction());
                    Map attrMap = this._getAttribute(attrNotif.getAttr());
                    if (attrMap != null) {
                        attrList.add(attrMap);
                    }
                }
            } else if (entityNotifs[iLoop].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ADD") != 0) {
                throw new IdASException("Unallowed entity notification type during entity creation: " + entityNotifs[iLoop].getAction());
            }
            ++iLoop;
        }
        changeMap.put(TEMPLATE_MAP_ENTITY_ATTR_LIST, attrList);
    }

    private void _addEntityUpdatesToChangeMap(Map changeMap, EntityNotification[] entityNotifs, int index) throws IdASException {
        IEntity entity = entityNotifs[index].getEntity();
        changeMap.put(TEMPLATE_MAP_ENTITY_TYPE, entity.getModel().getType().toString());
        ArrayList<Map> attrList = new ArrayList<Map>();
        Vector<URI> addedAttrIDs = new Vector<URI>();
        int iLoop = index;
        while (iLoop < entityNotifs.length) {
            if (entityNotifs[iLoop].getAction().compareTo("urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY") == 0) {
                AttributeNotification attrNotif = entityNotifs[iLoop].getAttributeNotification();
                URI attrID = attrNotif.getAttr().getType();
                if (!addedAttrIDs.contains(attrID)) {
                    Map attrMap = this._getAttribute(attrNotif);
                    attrList.add(attrMap);
                    String action = (String)attrMap.get(TEMPLATE_MAP_ATTRIBUTE_CHANGE_TYPE);
                    if (action.equals(TEMPLATE_MAP_ATTRIBUTE_ADD)) {
                        addedAttrIDs.add(attrID);
                    }
                }
            } else {
                throw new IdASException("Unallowed entity notification type during entity update: " + entityNotifs[iLoop].getAction());
            }
            ++iLoop;
        }
        changeMap.put(TEMPLATE_MAP_ENTITY_ATTR_LIST, attrList);
    }

    private Map _getAttribute(AttributeNotification attrNotif) throws IdASException {
        Map<String, String> attrMap = new HashMap();
        if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_VALUE_NOTIFY") == 0) {
            attrMap = this._getAttribute(attrNotif.getAttributeValueNotification(), attrNotif.getAttr().getType());
        } else if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD") == 0) {
            attrMap = this._getAttribute(attrNotif.getAttr());
        } else if (attrNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE") == 0) {
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_ID, attrNotif.getAttr().getType().toString());
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_REMOVE);
        } else {
            throw new IdASException("Unknown attribute notification processing entity update: " + attrNotif.getAction());
        }
        return attrMap;
    }

    private Map _getAttribute(ValueNotification attrValNotif, URI attrID) throws IdASException {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        ArrayList<Map> valueList = new ArrayList<Map>();
        attrMap.put(TEMPLATE_MAP_ATTRIBUTE_ID, attrID.toString());
        attrMap.put(TEMPLATE_MAP_ATTRIBUTE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_CHANGE);
        if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ADD") == 0) {
            Map attrValueMap = this._getValue(attrValNotif.getAttributeValue());
            attrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_VALUE_ADD);
            valueList.add(attrValueMap);
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUES, valueList);
        } else if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_REMOVE") == 0) {
            Map attrValueMap = this._getValue(attrValNotif.getAttributeValue());
            attrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_VALUE_REMOVE);
            valueList.add(attrValueMap);
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUES, valueList);
        } else if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_SET_DATA") == 0) {
            IValue value = attrValNotif.getAttributeValue();
            Map attrValueMap = this._getValue(value);
            attrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_VALUE_ADD);
            valueList.add(attrValueMap);
            ISimpleValue oldValue = BasicContext.createSimpleValue((URI)value.getType(), (Object)attrValNotif.getOldValueData(), null);
            Map oldAttrValueMap = this._getValue((IValue)oldValue);
            oldAttrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_VALUE_REMOVE);
            valueList.add(oldAttrValueMap);
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUES, valueList);
        } else if (attrValNotif.getAction().compareTo("urn:eclipse.higgins.idas.spi.AttributeValueNotification.UPDATE_ATTRIBUTE_NOTIFY") == 0) {
            HashMap<String, Object> attrValueMap = new HashMap<String, Object>();
            attrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE);
            Map attrValueAttrMap = this._getAttribute(attrValNotif.getAttributeNotification());
            ArrayList<Map> attrValueList = new ArrayList<Map>();
            attrValueList.add(attrValueAttrMap);
            attrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_ATTRIBUTE_LIST, attrValueList);
            valueList.add(attrValueMap);
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUES, valueList);
        }
        return attrMap;
    }

    private Map _getAttribute(IAttribute attr) throws IdASException {
        HashMap<String, Object> attrMap = new HashMap<String, Object>();
        ArrayList<Map> valueList = new ArrayList<Map>();
        attrMap.put(TEMPLATE_MAP_ATTRIBUTE_ID, attr.getType().toString());
        attrMap.put(TEMPLATE_MAP_ATTRIBUTE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_ADD);
        Iterator values = attr.getValues();
        while (values.hasNext()) {
            IValue attrVal = (IValue)values.next();
            Map attrValueMap = this._getValue(attrVal);
            attrMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_CHANGE_TYPE, TEMPLATE_MAP_ATTRIBUTE_VALUE_ADD);
            valueList.add(attrValueMap);
        }
        attrMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUES, valueList);
        return attrMap;
    }

    private Map _getValue(IValue attrVal) throws IdASException {
        HashMap<String, Object> attrValueMap = new HashMap<String, Object>();
        attrValueMap.put(TEMPLATE_MAP_VALUE_TYPE, attrVal.getType().toString());
        if (attrVal.isSimple()) {
            ISimpleValue simpleVal = (ISimpleValue)attrVal;
            attrValueMap.put(TEMPLATE_MAP_SIMPLE_VALUE, simpleVal.getData());
        }
        ArrayList<Map> attrList = new ArrayList<Map>();
        Iterator valueAttrs = attrVal.getAttributes();
        while (valueAttrs.hasNext()) {
            IAttribute valueAttr = (IAttribute)valueAttrs.next();
            Map valueMapAttr = this._getAttribute(valueAttr);
            if (valueMapAttr == null) continue;
            attrList.add(valueMapAttr);
        }
        if (attrList.size() > 0) {
            attrValueMap.put(TEMPLATE_MAP_ATTRIBUTE_VALUE_ATTRIBUTE_LIST, attrList);
        }
        return attrValueMap;
    }

    private DocumentBuilder _getDocumentBuilder() throws IdASException {
        if (this._docBuilder == null) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setNamespaceAware(true);
                this._docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IdASException((Throwable)e);
            }
        }
        return this._docBuilder;
    }

    public static String httpMethFailure(HttpMethod meth) {
        return String.valueOf(meth.getName()) + " request failed. code: " + meth.getStatusCode() + ", reason: " + meth.getStatusText();
    }

    private void _emitAuditRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._auditRecord != null) {
            try {
                this._auditRecord.clearRecord();
                this._auditRecord.setOriginatorInfo("Higgins IdAS JNDI Context Provider", null, null, null, null, null);
                if (sTargetInfo == null) {
                    sTargetInfo = "";
                }
                if (sEventInfo == null) {
                    sEventInfo = "";
                }
                this._auditRecord.setEventNumber(iEventNumber);
                this._auditRecord.setOutcome(iOutcome);
                this._auditRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                this._auditRecord.setTargetInfo(null, this._contextURIs, this._contextTypes, null, null, sTargetInfo);
                this._auditLog.info((Object)this._auditRecord);
            }
            catch (AuditException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }
}

