/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.rest.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IEntityModel;
import org.eclipse.higgins.idas.cp.rest.xml.RESTContext;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicContext;
import org.eclipse.higgins.idas.spi.BasicEntity;
import org.eclipse.higgins.idas.spi.BasicEntityModel;
import org.eclipse.higgins.idas.spi.EntityNotification;
import org.eclipse.higgins.idas.spi.IEntityContainer;
import org.eclipse.higgins.util.xml.DomFuncs;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RESTEntity
extends BasicEntity {
    private Log _log;
    private RESTContext _context;
    private IEntityContainer _container;
    private String _entityID;
    private HttpClient _httpClient;
    static /* synthetic */ Class class$0;

    public RESTEntity(RESTContext context, HttpClient httpClient, String entityID) throws IdASException {
        super((IContext)context);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.rest.xml.RESTEntity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._context = context;
        this._container = context;
        this._entityID = entityID;
        this._httpClient = httpClient;
        try {
            int httpCode;
            GetMethod meth = new GetMethod(String.valueOf(this._context.getEndpointURL()) + "/Entity/" + this._entityID);
            if (this._context.getSessionSecret() != null) {
                meth.addRequestHeader("SessionSecret", this._context.getSessionSecret());
            }
            if ((httpCode = this._httpClient.executeMethod((HttpMethod)meth)) != 200) {
                RESTContext.throwIdASException((HttpMethod)meth);
            }
            this._processResponse(httpCode, (HttpMethod)meth);
        }
        catch (HttpException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
    }

    public RESTEntity(RESTContext context, HttpClient httpClient, Element entityNode) throws IdASException {
        super((IContext)context);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.rest.xml.RESTEntity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._context = context;
        this._container = context;
        this._httpClient = httpClient;
        this._processEntityNode(entityNode);
    }

    private Document _getResponseDoc(HttpMethod meth) throws IdASException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(meth.getResponseBodyAsStream());
        }
        catch (ParserConfigurationException e) {
            throw new IdASException((Throwable)e);
        }
        catch (SAXException e) {
            throw new IdASException((Throwable)e);
        }
        catch (IOException e) {
            throw new IdASException((Throwable)e);
        }
    }

    private void _processResponse(int httpCode, HttpMethod meth) throws IdASException {
        try {
            Document doc = this._getResponseDoc(meth);
            Element entity = doc.getDocumentElement();
            this._processEntityNode(entity);
        }
        catch (Exception e) {
            throw new IdASException((Throwable)e);
        }
    }

    private void _processEntityNode(Element entityNode) throws IdASException {
        if (!DomFuncs.isElementNode((Node)entityNode, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"Entity")) {
            throw new IdASException("Unexpected response, expected: Entity");
        }
        String entityType = entityNode.getAttribute("entityType");
        if (entityType == null) {
            throw new IdASException("Unexpected response, expected: entityType");
        }
        this.setModel((IEntityModel)new BasicEntityModel(URI.create(entityType)));
        String entityID = entityNode.getAttribute("entityID");
        if (entityID == null) {
            throw new IdASException("Unexpected response, expected: entityID");
        }
        this._entityID = entityID;
        this._addAttributes(entityNode);
    }

    private void _addAttributes(Element attrElement) throws IdASException {
        Element attr = DomFuncs.getFirstChildElement((Node)attrElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"Attribute");
        while (attr != null) {
            this._addAttribute(attr);
            attr = DomFuncs.getNextSiblingElement((Node)attr, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"Attribute");
        }
    }

    private void _addAttribute(Element attrElement) throws IdASException {
        String attrID = attrElement.getAttribute("attrID");
        if (attrID == null) {
            throw new IdASException("Unexpected response, expected: attrID");
        }
        if (attrID.equals("http://www.eclipse.org/higgins/ontologies/2008/6/higgins#entityID")) {
            Element attrVal = DomFuncs.getFirstChildElement((Node)attrElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"AttributeValue");
            if (attrVal == null) {
                throw new IdASException("Unexpected response, expected: AttributeValue in http://www.eclipse.org/higgins/ontologies/2008/6/higgins#entityID");
            }
            if (DomFuncs.getNextSiblingElement((Node)attrVal, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"AttributeValue") != null) {
                throw new IdASException("Unexpected response, expected only 1 value in http://www.eclipse.org/higgins/ontologies/2008/6/higgins#entityID");
            }
            Element data = DomFuncs.getFirstChildElement((Node)attrVal, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"SimpleData");
            if (data == null) {
                throw new IdASException("Unexpected response, expected: SimpleData");
            }
            String entityID = DomFuncs.getNodeText((Node)data);
            if (entityID.trim().equals("")) {
                throw new IdASException("Unexepcted response, expected entity ID");
            }
            if (this._entityID == null) {
                this._entityID = entityID;
            } else if (entityID.compareTo(this._entityID) != 0) {
                throw new IdASException("Unexpected response, entity ID does match passed entity ID");
            }
        } else {
            BasicAttributeSet attrSet = this.getBasicAttributeSet();
            BasicAttribute attr = attrSet.addUnnotifiedAttribute(URI.create(attrID));
            this._addAttributeValues((IAttribute)attr, attrElement);
        }
    }

    private void _addAttributeValues(IAttribute attr, Element attrElement) throws IdASException {
        Element attrValElement = DomFuncs.getFirstChildElement((Node)attrElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"AttributeValue");
        while (attrValElement != null) {
            IValue value = null;
            boolean bValueIsSimple = true;
            URI dataTypeURI = null;
            String dataType = attrValElement.getAttribute("valType");
            if (dataType == null) {
                throw new IdASException("Unexpected response, expected: valType in " + attr.getType().toString());
            }
            if (dataType.trim().equals("")) {
                throw new IdASException("Unexpected response, expected dataType");
            }
            dataTypeURI = URI.create(dataType);
            value = attr.addValue(dataTypeURI);
            bValueIsSimple = value.isSimple();
            if (bValueIsSimple) {
                Element dataElement = DomFuncs.getFirstChildElement((Node)attrValElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"SimpleData");
                if (dataElement == null) {
                    throw new IdASException("Unexpected response, expected: SimpleData in " + attr.getType().toString());
                }
                ISimpleValue tmpSimpleValue = BasicContext.createSimpleValue((URI)dataTypeURI, (Object)DomFuncs.getNodeText((Node)dataElement), null);
                ((ISimpleValue)value).setData(tmpSimpleValue.getData());
                this._addAttributes(attrValElement);
            } else {
                if (DomFuncs.getFirstChildElement((Node)attrValElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"SimpleData") != null) {
                    throw new IdASException("Unexpected response, expected complex type in " + attr.getType().toString());
                }
                this._addAttributes(attrValElement);
            }
            attrValElement = DomFuncs.getNextSiblingElement((Node)attrValElement, (String)"http://www.eclipse.org/higgins/idas/rest-xml/2008/6", (String)"AttributeValue");
        }
    }

    public IContext getContext() throws IdASException {
        return this._context;
    }

    public String getEntityID() throws IdASException {
        return this._entityID;
    }

    public URI getEntityType() throws IdASException {
        return this.getModel().getType();
    }

    public void remove() throws IdASException {
        if (this._container != null) {
            this._container.updateNotification(new EntityNotification((IEntity)this, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_REMOVE", null));
        }
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        return super.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return super.addAttribute(copyFrom);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return super.equals(attributes);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        IAttribute attr = super.getAttribute(attrID);
        if (attr == null) {
            try {
                int httpCode;
                GetMethod meth = new GetMethod(String.valueOf(this._context.getEndpointURL()) + "/Entity/" + this._entityID + "?attr=" + URLEncoder.encode(attrID.toString(), "UTF-8"));
                if (this._context.getSessionSecret() != null) {
                    meth.addRequestHeader("SessionSecret", this._context.getSessionSecret());
                }
                if ((httpCode = this._httpClient.executeMethod((HttpMethod)meth)) != 200) {
                    RESTContext.throwIdASException((HttpMethod)meth);
                }
                this._processResponse(httpCode, (HttpMethod)meth);
            }
            catch (HttpException e) {
                throw new IdASException((Throwable)e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
            attr = super.getAttribute(attrID);
        }
        return attr;
    }

    public Iterator getAttributes() throws IdASException {
        Iterator iter = super.getAttributes();
        if (!iter.hasNext()) {
            GetMethod meth = new GetMethod(String.valueOf(this._context.getEndpointURL()) + "/Entity/" + this._entityID);
            try {
                int httpCode;
                if (this._context.getSessionSecret() != null) {
                    meth.addRequestHeader("SessionSecret", this._context.getSessionSecret());
                }
                if ((httpCode = this._httpClient.executeMethod((HttpMethod)meth)) != 200) {
                    RESTContext.throwIdASException((HttpMethod)meth);
                }
                this._processResponse(httpCode, (HttpMethod)meth);
            }
            catch (HttpException e) {
                throw new IdASException((Throwable)e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
            iter = super.getAttributes();
        }
        return iter;
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return super.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        super.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        super.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        super.removeAttributeValue(attr);
    }

    public void updateNotification(AttributeNotification attrNotif) throws IdASException {
        if (this._container != null) {
            this._container.updateNotification(new EntityNotification((IEntity)this, "urn:eclipse.higgins.idas.spi.EntityNotification.UPDATE_ATTR_NOTIFY", attrNotif));
        }
    }
}

