/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.xml.LocalID;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class AuthenticationService
extends Service {
    public static final String SERVICE_TYPE1 = "http://openid.net/signon/1.0";
    public static final String SERVICE_TYPE2 = "http://specs.openid.net/auth/2.0/signon";
    public static final String LOGIN_PATH = "(+login)";
    public static final Integer URI_PRIORITY_HTTPS = new Integer(1);
    public static final Integer URI_PRIORITY_DEFAULT = new Integer(2);

    public AuthenticationService(URI[] authenticationPages, String providerID, String delegate, boolean useLoginPath) {
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addType(new SEPType(SERVICE_TYPE1, null, Boolean.TRUE));
        this.addType(new SEPType(SERVICE_TYPE2, null, Boolean.TRUE));
        this.addMediaType(new SEPMediaType(null, "default", null));
        if (delegate != null) {
            this.addLocalID(new LocalID(delegate));
        }
        if (useLoginPath) {
            this.addPath(new SEPPath(LOGIN_PATH, null, Boolean.TRUE));
            this.addPath(new SEPPath(null, "default", null));
        }
        for (int i = 0; i < authenticationPages.length; ++i) {
            URI authenticationPage = authenticationPages[i];
            try {
                Integer priority = authenticationPage.getScheme() != null && authenticationPage.getScheme().toLowerCase().equals("https") ? URI_PRIORITY_HTTPS : URI_PRIORITY_DEFAULT;
                this.addURI(new SEPUri(authenticationPage.toString(), priority, "none"));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public AuthenticationService(URI authenticationPage, String providerID, String delegate, boolean useLoginPath) {
        this(new URI[]{authenticationPage}, providerID, delegate, useLoginPath);
    }

    public AuthenticationService(URI[] authenticationPages, String providerID, String delegate) {
        this(authenticationPages, providerID, delegate, true);
    }

    public AuthenticationService(URI authenticationPage, String providerID, String delegate) {
        this(new URI[]{authenticationPage}, providerID, delegate, true);
    }

    public AuthenticationService(URI[] authenticationPages, String providerID) {
        this(authenticationPages, providerID, null, true);
    }

    public AuthenticationService(URI authenticationPage, String providerID) {
        this(new URI[]{authenticationPage}, providerID, null, true);
    }

    public AuthenticationService(URI[] authenticationPages) {
        this(authenticationPages, null, null, true);
    }

    public AuthenticationService(URI authenticationPage) {
        this(new URI[]{authenticationPage}, null, null, true);
    }

    public static boolean isInstance(Service service) {
        if (service instanceof AuthenticationService) {
            return true;
        }
        List serviceTypes = service.getTypes();
        for (int i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (SERVICE_TYPE1.equals(serviceType.getValue())) {
                return true;
            }
            if (!SERVICE_TYPE2.equals(serviceType.getValue())) continue;
            return true;
        }
        return false;
    }
}

