/*******************************************************************************
 * Copyright (c) 2009 Azigo, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.cp.xdi;

import java.net.URI;
import java.util.Iterator;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.common.SimpleValueSerializer;
import org.eclipse.higgins.idas.spi.BasicSimpleValueModel;
import org.eclipse.higgins.xdi4j.Graph;
import org.eclipse.higgins.xdi4j.Literal;
import org.eclipse.higgins.xdi4j.addressing.Addressing;
import org.eclipse.higgins.xdi4j.messaging.Message;
import org.eclipse.higgins.xdi4j.messaging.ModOperation;
import org.eclipse.higgins.xdi4j.util.CopyUtil;
import org.eclipse.higgins.xdi4j.xri3.impl.XRI3;

public class XDISimpleAttrValue implements ISimpleValue {

	private XDIContext context;

	private XRI3 address;

	private Object data;
	private ISimpleValueModel model;

	public XDISimpleAttrValue(XDIContext context, XRI3 address, Object data, URI type) {

		this.context = context;

		this.address = address;

		this.data = data;
		this.model = new BasicSimpleValueModel(type);
	}

	public ISimpleValueModel getModel() {

		return(this.model);
	}

	public Object getData() throws IdASException {

		return(this.data);
	}

	public String getLexical() throws IdASException {

		return(this.data.toString());
	}

	public String getCanonical() throws IdASException {

		return(this.data.toString());
	}

//	public URI getDataType() throws IdASException {
//
//		return(this.model.getType());
//	}
//
//	public URI getValueType() throws IdASException {
//
//		return(this.model.getType());
//	}

	public boolean isSimple() throws IdASException {

		return(true);
	}

	public void setData(Object data) throws IdASException {

		this.data = data;

		String dataStr = SimpleValueSerializer.serialize(data);

		Message applyMessage = this.context.getApplyMessage();
		ModOperation operation = applyMessage.getModOperation();
		if (operation == null) operation = applyMessage.createModOperation();
		Graph operationGraph = operation.getOperationGraph();
		if (operationGraph == null) operationGraph = operation.createOperationGraph(null);
		CopyUtil.copyStatements(Addressing.convertAddressToGraph(new XRI3(this.address.toString() + "/''")), operationGraph, null);
		Literal literal = (Literal) Addressing.findByAddress(operationGraph, this.address)[0];
		literal.setData(dataStr);
	}

	public void remove() throws IdASException {

		// TODO: send XDI message
	}

	public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {

		throw new NotImplementedException();
	}

	public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {

		throw new NotImplementedException();
	}

	public IAttribute getAttribute(URI attrID) throws IdASException {

		throw new NotImplementedException();
	}

	public Iterator getAttributes() throws IdASException {

		throw new NotImplementedException();
	}

	public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {

		throw new NotImplementedException();
	}

	public void removeAttributeValue(URI attrID, Object value) throws IdASException {

		throw new NotImplementedException();
	}

	public void removeAttributeValue(IAttribute attr) throws IdASException {

		throw new NotImplementedException();
	}

	public void removeAttribute(URI attrID) throws IdASException {

		throw new NotImplementedException();
	}

	public boolean equals(IValue value) throws IdASException {

		throw new NotImplementedException();
	}

	public boolean equals(IHasAttributes attributes) throws IdASException {

		throw new NotImplementedException();
	}

	public URI getType() throws IdASException {
		return (this.model.getType());
	}

	public IValueModel getValueModel() {
		return getModel();
	}

	public IEntity addAttributeValue(URI attrType, String entityId) throws IdASException {
		// TODO Auto-generated method stub
		return null;
	}
}
