/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import java.util.ArrayList;
import org.openxri.xri3.XRI;
import org.openxri.xri3.XRIAuthority;
import org.openxri.xri3.XRIFragment;
import org.openxri.xri3.XRIPath;
import org.openxri.xri3.XRIQuery;
import org.openxri.xri3.XRIReference;
import org.openxri.xri3.XRISyntaxComponent;
import org.openxri.xri3.impl.XRI3;
import org.openxri.xri3.impl.XRI3Fragment;
import org.openxri.xri3.impl.XRI3Path;
import org.openxri.xri3.impl.XRI3Query;
import org.openxri.xri3.impl.XRI3SyntaxComponent;
import org.openxri.xri3.impl.XRI3Util;
import org.openxri.xri3.impl.parser.Parser;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;

public class XRI3Reference
extends XRI3SyntaxComponent
implements XRIReference {
    private static final long serialVersionUID = 4191016969141944835L;
    private Rule rule;
    private XRI3 xri;
    private XRI3Path path;
    private XRI3Query query;
    private XRI3Fragment fragment;

    public XRI3Reference(String string) throws ParserException {
        this.rule = XRI3Util.getParser().parse("xri-reference", string);
        this.read();
    }

    public XRI3Reference(XRIReference xriReference, XRISyntaxComponent xriPart) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(xriReference.toString());
        buffer.append(xriPart.toString());
        this.rule = XRI3Util.getParser().parse("xri-reference", buffer.toString());
        this.read();
    }

    public XRI3Reference(XRIReference xriReference, String xriPart) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(xriReference.toString());
        buffer.append(xriPart);
        this.rule = XRI3Util.getParser().parse("xri-reference", buffer.toString());
        this.read();
    }

    XRI3Reference(Rule rule) {
        this.rule = rule;
        this.read();
    }

    private void reset() {
        this.xri = null;
        this.path = null;
        this.query = null;
        this.fragment = null;
    }

    private void read() {
        this.reset();
        Rule object = this.rule;
        ArrayList list_xri_reference = ((Parser.xri_reference)object).rules;
        if (list_xri_reference.size() < 1) {
            return;
        }
        object = list_xri_reference.get(0);
        if (object instanceof Parser.xri) {
            this.xri = new XRI3((Parser.xri)object);
        } else if (object instanceof Parser.relative_xri_ref) {
            ArrayList list_relative_xri_ref = ((Parser.relative_xri_ref)object).rules;
            if (list_relative_xri_ref.size() < 1) {
                return;
            }
            object = list_relative_xri_ref.get(0);
            ArrayList list_relative_xri_part = ((Parser.relative_xri_part)object).rules;
            if (list_relative_xri_part.size() < 1) {
                return;
            }
            object = list_relative_xri_part.get(0);
            if (object instanceof Parser.xri_path_abs) {
                this.path = new XRI3Path((Parser.xri_path_abs)object);
            } else if (object instanceof Parser.xri_path_noscheme) {
                this.path = new XRI3Path((Parser.xri_path_noscheme)object);
            } else if (object instanceof Parser.ipath_empty) {
                this.path = new XRI3Path((Parser.ipath_empty)object);
            } else {
                throw new ClassCastException(object.getClass().getName());
            }
            if (list_relative_xri_ref.size() < 3) {
                return;
            }
            object = list_relative_xri_ref.get(2);
            this.query = new XRI3Query((Parser.iquery)object);
            if (list_relative_xri_ref.size() < 5) {
                return;
            }
            object = list_relative_xri_ref.get(4);
            this.fragment = new XRI3Fragment((Parser.ifragment)object);
        } else {
            throw new ClassCastException(object.getClass().getName());
        }
    }

    public Rule getParserObject() {
        return this.rule;
    }

    public boolean hasAuthority() {
        if (this.xri != null) {
            return this.xri.hasAuthority();
        }
        return false;
    }

    public boolean hasPath() {
        if (this.xri != null) {
            return this.xri.hasPath();
        }
        return this.path != null;
    }

    public boolean hasQuery() {
        if (this.xri != null) {
            return this.xri.hasQuery();
        }
        return this.query != null;
    }

    public boolean hasFragment() {
        if (this.xri != null) {
            return this.xri.hasFragment();
        }
        return this.fragment != null;
    }

    public XRIAuthority getAuthority() {
        if (this.xri != null) {
            return this.xri.getAuthority();
        }
        return null;
    }

    public XRIPath getPath() {
        if (this.xri != null) {
            return this.xri.getPath();
        }
        return this.path;
    }

    public XRIQuery getQuery() {
        if (this.xri != null) {
            return this.xri.getQuery();
        }
        return this.query;
    }

    public XRIFragment getFragment() {
        if (this.xri != null) {
            return this.xri.getFragment();
        }
        return this.fragment;
    }

    public String toIRINormalForm() {
        if (this.xri != null) {
            return this.xri.toIRINormalForm();
        }
        return super.toIRINormalForm();
    }

    public boolean isValidXRI() {
        XRI xri2;
        try {
            xri2 = this.toXRI();
        }
        catch (Exception ex) {
            return false;
        }
        return xri2 != null;
    }

    public XRI toXRI() throws ParserException {
        return new XRI3(this.toString());
    }

    public XRI3 toXRI3() throws ParserException {
        return new XRI3(this.toString());
    }
}

