/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;

public class AttrIterator
implements Iterator {
    private NonsharedContext _nonsharedContext;
    private NonsharedAttrContainer _nonsharedContainer;
    private SharedAttribute _currAttr;
    private int _iCurrAttrNum;

    public AttrIterator(NonsharedAttrContainer container) {
        this._nonsharedContainer = container;
        this._nonsharedContext = this._nonsharedContainer.getNonSharedContext();
        this._currAttr = null;
        this._iCurrAttrNum = -1;
    }

    private boolean _syncAttr(boolean bMustFindExact) throws IdASException {
        String szAttrID;
        ArrayList attrList = this._nonsharedContainer.getAttrList();
        Map attrMap = this._nonsharedContainer.getAttrMap();
        SharedAttribute sharedAttr = (SharedAttribute)attrMap.get(szAttrID = this._currAttr.getAttrID());
        if (sharedAttr != null) {
            this._currAttr = sharedAttr;
            if (this._iCurrAttrNum > attrList.size() || this._currAttr != (SharedAttribute)attrList.get(this._iCurrAttrNum)) {
                this._iCurrAttrNum = 0;
                while (this._iCurrAttrNum < attrList.size() && this._currAttr != (SharedAttribute)attrList.get(this._iCurrAttrNum)) {
                    ++this._iCurrAttrNum;
                }
            }
        } else {
            if (bMustFindExact) {
                return false;
            }
            --this._iCurrAttrNum;
            if (this._iCurrAttrNum >= 0 && this._iCurrAttrNum < attrList.size()) {
                this._currAttr = (SharedAttribute)attrList.get(this._iCurrAttrNum);
            } else {
                this._nonsharedContainer = null;
                return false;
            }
        }
        return true;
    }

    private int _getNextAttrNum() {
        boolean bSyncedContainer = false;
        try {
            int iNextAttrNum;
            if (this._nonsharedContainer != null) {
                try {
                    bSyncedContainer = this._nonsharedContainer.sync(false);
                }
                catch (Exception e) {
                    this._nonsharedContainer = null;
                }
            }
            if (this._nonsharedContainer == null) {
                return -1;
            }
            if (bSyncedContainer && this._currAttr != null && !this._syncAttr(false)) {
                return -1;
            }
            if (this._currAttr == null) {
                iNextAttrNum = 0;
            } else {
                if (this._currAttr.isDeleted() && !this._syncAttr(false)) {
                    return -1;
                }
                iNextAttrNum = this._iCurrAttrNum + 1;
            }
            if (iNextAttrNum >= this._nonsharedContainer.getAttrList().size()) {
                return -1;
            }
            return iNextAttrNum;
        }
        catch (IdASException idASException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        int iNextAttrNum = -1;
        if (!this._nonsharedContext.isOpen()) {
            return false;
        }
        try {
            this._nonsharedContext.lockSharedContext();
            iNextAttrNum = this._getNextAttrNum();
        }
        catch (IdASException e) {
            iNextAttrNum = -1;
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        if (iNextAttrNum == -1) {
            this._nonsharedContainer = null;
            return false;
        }
        return true;
    }

    public Object next() {
        if (!this._nonsharedContext.isOpen()) {
            throw new NoSuchElementException();
        }
        try {
            this._nonsharedContext.lockSharedContext();
            int iNextAttrNum = this._getNextAttrNum();
            if (iNextAttrNum == -1) {
                this._nonsharedContainer = null;
                this._currAttr = null;
                throw new NoSuchElementException();
            }
            ArrayList attrList = this._nonsharedContainer.getAttrList();
            this._currAttr = (SharedAttribute)attrList.get(iNextAttrNum);
            this._iCurrAttrNum = iNextAttrNum;
        }
        catch (IdASException e) {
            throw new NoSuchElementException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return new NonsharedAttribute(this._nonsharedContainer, this._currAttr);
    }

    public void remove() {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new IllegalStateException("IdAS context is no longer open");
        }
        if (this._currAttr == null || this._currAttr.isDeleted()) {
            throw new IllegalStateException();
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            if (this._nonsharedContainer.sync(bStartedTrans) && !this._syncAttr(true)) {
                throw new NoSuchElementException();
            }
            this._currAttr.remove();
        }
        catch (IdASException e) {
            throw new IllegalStateException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }
}

