/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedNode;
import org.eclipse.higgins.idas.cp.xmlfile.SharedNode;

public class NodeIterator
implements Iterator {
    private NonsharedContext _nonsharedContext;
    private IFilter _basicFilter;
    private SharedNode _currNode;
    private int _iCurrNodeNum;

    NodeIterator(NonsharedContext context, IFilter basicFilter) {
        this._nonsharedContext = context;
        this._basicFilter = basicFilter;
        this._currNode = null;
        this._iCurrNodeNum = -1;
    }

    private boolean _syncNode(boolean bMustFindExact) throws IdASException {
        String szNodeID;
        ArrayList nodeList = this._nonsharedContext.getSharedContext().getNodeList();
        Map nodeMap = this._nonsharedContext.getSharedContext().getNodeMap();
        SharedNode sharedNode = (SharedNode)nodeMap.get(szNodeID = this._currNode.getNodeID());
        if (sharedNode != null) {
            this._currNode = sharedNode;
            if (this._iCurrNodeNum >= nodeList.size() || this._currNode != (SharedNode)nodeList.get(this._iCurrNodeNum)) {
                this._iCurrNodeNum = 0;
                while (this._iCurrNodeNum < nodeList.size() && this._currNode != (SharedNode)nodeList.get(this._iCurrNodeNum)) {
                    ++this._iCurrNodeNum;
                }
            }
        } else {
            if (bMustFindExact) {
                return false;
            }
            --this._iCurrNodeNum;
            if (this._iCurrNodeNum >= 0 && this._iCurrNodeNum < nodeList.size()) {
                this._currNode = (SharedNode)nodeList.get(this._iCurrNodeNum);
            } else {
                return false;
            }
        }
        return true;
    }

    private int _getNextNodeNum() {
        try {
            int iNextNodeNum;
            if (this._nonsharedContext.sync(false) && this._currNode != null && !this._syncNode(false)) {
                return -1;
            }
            if (this._currNode == null) {
                iNextNodeNum = 0;
            } else {
                if (this._currNode.isDeleted() && !this._syncNode(false)) {
                    return -1;
                }
                iNextNodeNum = this._iCurrNodeNum + 1;
            }
            ArrayList nodeList = this._nonsharedContext.getSharedContext().getNodeList();
            while (iNextNodeNum < nodeList.size()) {
                if (this._nonsharedContext.getSharedContext().testNode((SharedNode)nodeList.get(iNextNodeNum), this._basicFilter)) {
                    return iNextNodeNum;
                }
                ++iNextNodeNum;
            }
        }
        catch (IdASException idASException) {
            // empty catch block
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        int iNextNodeNum = -1;
        if (!this._nonsharedContext.isOpen()) {
            return false;
        }
        try {
            this._nonsharedContext.lockSharedContext();
            iNextNodeNum = this._getNextNodeNum();
        }
        catch (IdASException e) {
            iNextNodeNum = -1;
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return iNextNodeNum != -1;
    }

    public Object next() {
        if (!this._nonsharedContext.isOpen()) {
            throw new NoSuchElementException();
        }
        try {
            this._nonsharedContext.lockSharedContext();
            int iNextNodeNum = this._getNextNodeNum();
            if (iNextNodeNum == -1) {
                this._currNode = null;
                throw new NoSuchElementException();
            }
            ArrayList nodeList = this._nonsharedContext.getSharedContext().getNodeList();
            this._currNode = (SharedNode)nodeList.get(iNextNodeNum);
            this._iCurrNodeNum = iNextNodeNum;
        }
        catch (IdASException e) {
            throw new NoSuchElementException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return new NonsharedNode(this._nonsharedContext, this._currNode);
    }

    public void remove() {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new IllegalStateException("IdAS context is no longer open");
        }
        if (this._currNode == null || this._currNode.isDeleted()) {
            throw new IllegalStateException();
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            if (this._nonsharedContext.sync(bStartedTrans) && !this._syncNode(true)) {
                throw new NoSuchElementException();
            }
            this._currNode.remove();
        }
        catch (IdASException e) {
            throw new IllegalStateException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }
}

