/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import openxdas.XDasException;
import openxdas.XDasRecord;
import openxdas.XDasSession;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.INode;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NodeExistsException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.cp.xmlfile.NodeIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedNode;
import org.eclipse.higgins.idas.cp.xmlfile.SharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedNode;
import org.eclipse.higgins.idas.spi.BasicContext;

public class NonsharedContext
extends BasicContext {
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext = NonsharedContext.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext).getName());
    private SharedContext _readOnlyContext;
    private SharedContext _updateContext;
    private String _szNodeID;
    private XDasSession _xdasSession;
    private Object _identity = null;
    private int _iLockCount = 0;
    private boolean _bIsOpen = false;
    private long _lLastModifiedTime;
    private String _szContextURIs;
    private String _szContextTypes;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedContext;

    public NonsharedContext(SharedContext readOnlyContext, String szContextURIs, String szContextTypes) throws IdASException {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure((Appender)new NullAppender());
        }
        this._szContextURIs = szContextURIs;
        this._szContextTypes = szContextTypes;
        this._readOnlyContext = readOnlyContext;
        this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
        this._updateContext = null;
        this._bIsOpen = false;
        this._iLockCount = 0;
        this._identity = null;
        this._szNodeID = null;
        this._xdasSession = null;
        this._initXDASSession();
    }

    boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._updateContext != null) {
            bSynced = bForceSync;
        } else if (bForceSync || this._lLastModifiedTime != this._readOnlyContext.getLastModifiedTime()) {
            this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
            bSynced = true;
        }
        return bSynced;
    }

    private void _initXDASSession() throws IdASException {
        try {
            this._xdasSession = new XDasSession("Higgins IdAS XML File Context Provider", null, null, null, null, null);
        }
        catch (XDasException e) {
            throw new IdASException((Throwable)e);
        }
        catch (SocketException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _emitXDASRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._xdasSession != null) {
            if (sTargetInfo == null) {
                sTargetInfo = "";
            }
            if (sEventInfo == null) {
                sEventInfo = "";
            }
            try {
                XDasRecord xdasRecord = this._xdasSession.XDasStartRecord(iEventNumber, iOutcome, null, null, sEventInfo);
                xdasRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                xdasRecord.setTargetInfo(null, this._szContextURIs, this._szContextTypes, null, null, sTargetInfo);
                xdasRecord.commit();
            }
            catch (XDasException e) {
                throw new IdASException((Throwable)e);
            }
            catch (IOException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    void lockSharedContext() throws IdASException {
        if (this._iLockCount == 0) {
            this._readOnlyContext.lock();
            this._readOnlyContext.syncFile();
        }
        ++this._iLockCount;
    }

    void unlockSharedContext() {
        --this._iLockCount;
        if (this._iLockCount == 0) {
            this._readOnlyContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String open(Object identity) throws IdASException {
        if (this._bIsOpen) {
            throw new ContextOpenException("nonsharedContext:open(): Context already open");
        }
        try {
            this.lockSharedContext();
            this._szNodeID = this._readOnlyContext.open(identity);
            this._bIsOpen = true;
            this._identity = identity instanceof AuthNAnonymousMaterials ? "[ANONYMOUS]" : identity;
        }
        finally {
            this.unlockSharedContext();
        }
        return this._szNodeID;
    }

    protected void finalize() {
        if (this._bIsOpen) {
            try {
                this.close();
            }
            catch (IdASException idASException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonSharedContext:close(): Context not open");
        }
        this._emitXDASRecord(0x1000008, 0, this._identity.toString(), null, null);
        this._log.debug((Object)("Context closed: " + this._szContextURIs + " as: " + this._identity.toString()));
        if (this._readOnlyContext != null) {
            if (this._iLockCount > 0) {
                this._readOnlyContext.unlock();
                this._iLockCount = 0;
            }
            HashMap hashMap = NonsharedContextFactory.SharedContextTable;
            synchronized (hashMap) {
                this._readOnlyContext.decrOpenCount();
                this._readOnlyContext.setLastCloseTime(System.currentTimeMillis());
            }
            this._readOnlyContext = null;
        }
        this._bIsOpen = false;
        this._identity = null;
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    boolean isOpen() {
        return this._bIsOpen;
    }

    SharedContext getSharedContext() {
        return this._updateContext == null ? this._readOnlyContext : this._updateContext;
    }

    boolean beginTrans() throws IdASException {
        this.lockSharedContext();
        if (this._updateContext == null) {
            this._updateContext = new SharedContext(this._readOnlyContext);
            return true;
        }
        return false;
    }

    public String getSchema() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonSharedContext:getSchema()");
    }

    public INode getNode(String szNodeID) throws IdASException {
        return this.getNode(szNodeID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode getNode(String szNodeID, Iterator consumerSelectionList) throws IdASException {
        SharedNode sharedNode = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getNode(NodeID,attrList): Context not open");
        }
        try {
            this.lockSharedContext();
            sharedNode = this.getSharedContext().getNode(szNodeID);
        }
        finally {
            this.unlockSharedContext();
        }
        return sharedNode == null ? null : new NonsharedNode(this, sharedNode);
    }

    public Iterator getNodes(IFilter filter) throws IdASException {
        return this.getNodes(filter, null);
    }

    public Iterator getNodes(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getNodes(filter,attrlist): Context not open");
        }
        this._emitXDASRecord(0x1000005, 0, this._identity.toString(), filter.toString(), null);
        this._log.debug((Object)("Searching for Nodes matching filter: " + filter.toString() + " as: " + this._identity.toString() + " in context: " + this._szContextURIs));
        return new NodeIterator(this, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(String szNodeID) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:removeNode(nodeID): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            this._updateContext.removeNode(szNodeID);
        }
        finally {
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode addNode(URI type, String szNodeID) throws IdASException {
        boolean bStartedTrans = false;
        SharedNode sharedNode = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addNode(type,nodeID): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedNode = this._updateContext.addNode(type, szNodeID);
        }
        finally {
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
        }
        return sharedNode == null ? null : new NonsharedNode(this, sharedNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INode addNode(INode copyFrom) throws IdASException, NodeExistsException {
        boolean bStartedTrans = false;
        SharedNode sharedNode = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addNode(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedNode = this._updateContext.addNode(copyFrom);
        }
        finally {
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
        }
        return sharedNode == null ? null : new NonsharedNode(this, sharedNode);
    }

    public void applyUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext.applyUpdates();
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    public void cancelUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

