/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.INode;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NoSuchNodeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.INodeModel;
import org.eclipse.higgins.idas.cp.xmlfile.AttrIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedNode;

public class NonsharedNode
implements INode,
NonsharedAttrContainer {
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedNode == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedNode = NonsharedNode.class$("org.eclipse.higgins.idas.cp.xmlfile.NonsharedNode")) : class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedNode).getName());
    private NonsharedContext _nonsharedContext;
    private SharedNode _sharedNode;
    private String _szNodeID;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$NonsharedNode;

    NonsharedNode(NonsharedContext nonsharedCtx, SharedNode sharedNode) {
        this._nonsharedContext = nonsharedCtx;
        this._sharedNode = sharedNode;
        this._szNodeID = this._sharedNode.getNodeID();
    }

    public NonsharedContext getNonSharedContext() {
        return this._nonsharedContext;
    }

    public SharedAttrContainer getSharedContainer() {
        return this._sharedNode;
    }

    public ArrayList getAttrList() {
        return this._sharedNode.getAttrList();
    }

    public Map getAttrMap() {
        return this._sharedNode.getAttrMap();
    }

    public String getContainerType() {
        return "Node";
    }

    public String getContainerID() {
        return this._szNodeID;
    }

    public boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._nonsharedContext.sync(bForceSync)) {
            bForceSync = true;
        }
        if (bForceSync || this._sharedNode == null || this._sharedNode.isDeleted()) {
            this._sharedNode = this._nonsharedContext.getSharedContext().getNode(this._szNodeID);
            bSynced = true;
        }
        if (this._sharedNode == null) {
            String szErrMsg = "Node '" + this._szNodeID + "' no longer exists";
            this._log.debug((Object)szErrMsg);
            throw new NoSuchNodeException(szErrMsg);
        }
        return bSynced;
    }

    public IContext getContext() throws IdASException {
        return this._nonsharedContext;
    }

    public String getNodeID() throws IdASException {
        return this._szNodeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getNodeType() throws IdASException {
        URI nodeType = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:getNodeType(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            nodeType = URI.create(this._sharedNode.getNodeType());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return nodeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAttributes() throws IdASException {
        AttrIterator iter = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:getAttributes(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            iter = new AttrIterator(this);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute getAttribute(URI attrID) throws IdASException {
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:getAttribute(attrID): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            sharedAttr = this._sharedNode.getAttribute(attrID.toString());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    public INodeModel getModel() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedNode:getModel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:remove(): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedNode.remove();
            this._sharedNode = null;
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:getSingleValuedAttribute(): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            sharedAttr = this._sharedNode.getSingleValuedAttribute(attrID.toString());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        boolean bStartedTrans = false;
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:addAttribute(attrID): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            sharedAttr = this._sharedNode.addAttribute(attrID.toString());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        boolean bStartedTrans = false;
        SharedAttribute sharedAttr = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:addAttribute(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            sharedAttr = this._sharedNode.addAttribute(copyFrom);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
        return sharedAttr == null ? null : new NonsharedAttribute(this, sharedAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(URI attrID) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:removeAttribute(attrID): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedNode.removeAttribute(attrID.toString());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:removeAttributeValue(attrID,value): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedNode.removeAttributeValue(attrID.toString(), value);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeValue(IAttribute attr) throws IdASException {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:removeAttributeValue(IAttribute): Context not open");
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            this.sync(bStartedTrans);
            this._sharedNode.removeAttributeValue(attr);
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(IHasAttributes attributes) throws IdASException {
        boolean bEqual = true;
        if (!this._nonsharedContext.isOpen()) {
            throw new ContextNotOpenException("nonsharedNode:equals(IHasAttributes): Context not open");
        }
        try {
            this._nonsharedContext.lockSharedContext();
            this.sync(false);
            bEqual = this._sharedNode.equals(attributes);
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return bEqual;
    }

    public Iterator getMetadataSet() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedNode:getMetadataSet()");
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedNode:getMetadata(metadataID)");
    }

    public IMetadata addMetadata(URI metadataID) throws IdASException, InvalidTypeException {
        throw new NotImplementedException("Not Implemented: nonsharedNode:addMetadata(metadataID)");
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedNode:addMetadata(copyFrom)");
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedNode:equals(metadataSet)");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

