/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.eclipse.higgins.idas.api.AuthenticationException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.INode;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchNodeException;
import org.eclipse.higgins.idas.api.NodeExistsException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.common.AuthNSelfIssuedMaterials;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttributeValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedComplexAttrValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedNode;
import org.eclipse.higgins.idas.cp.xmlfile.SharedSimpleAttrValue;
import org.eclipse.higgins.idas.spi.BasicFilter;
import org.eclipse.higgins.idas.spi.BasicFilterAssertion;
import org.eclipse.higgins.idas.spi.BasicFilterAttributeAssertion;
import org.eclipse.higgins.idas.spi.BasicValueBase64Binary;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SharedContext
extends Thread {
    public static final String XML_CONTEXT_ELEMENT = "Context";
    public static final String XML_NODE_ELEMENT = "Node";
    public static final String XML_ATTRIBUTE_ELEMENT = "Attribute";
    public static final String XML_ATTRIBUTE_VALUE_ELEMENT = "AttributeValue";
    public static final String XML_ATTR_ID_ATTR = "AttrID";
    public static final String XML_NODE_TYPE_ATTR = "NodeType";
    public static final String XML_DATA_TYPE_ATTR = "DataType";
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$cp$xmlfile$SharedContext == null ? (class$org$eclipse$higgins$idas$cp$xmlfile$SharedContext = SharedContext.class$("org.eclipse.higgins.idas.cp.xmlfile.SharedContext")) : class$org$eclipse$higgins$idas$cp$xmlfile$SharedContext).getName());
    private int _iOpenCount;
    private long _lLastCloseTime;
    private HashMap _nodeMap;
    private ArrayList _nodeList;
    private String _szFileName;
    private long _lLastModifiedTime;
    private File _file;
    private boolean _bLocked;
    private String _szUserNameAttr;
    private String _szPasswordAttr;
    private String _szCardKeyHashAttr;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$cp$xmlfile$SharedContext;

    SharedContext(String szFileName) throws IdASException {
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            BasicConfigurator.configure((Appender)new NullAppender());
        }
        this._bLocked = false;
        this._file = new File(szFileName);
        try {
            this._szFileName = this._file.getCanonicalPath();
        }
        catch (IOException e) {
            String szErrMsg = "Error getting canonical path for file '" + szFileName + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        this._initPresetAttrs();
        this._nodeMap = new HashMap();
        this._nodeList = new ArrayList();
        if (!this._file.exists()) {
            this._createFile();
        } else {
            if (this._file.isDirectory()) {
                String szErrMsg = "Specified XML file '" + this._szFileName + " is a directory, cannot open";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            this._parseFileToDOM();
        }
    }

    private void _initPresetAttrs() {
        this._szUserNameAttr = AuthNNamePasswordMaterials.ATTR_TYPE_USERNAME.toString();
        this._szPasswordAttr = AuthNNamePasswordMaterials.ATTR_MANAGED_URI.toString();
        this._szCardKeyHashAttr = AuthNSelfIssuedMaterials.MANAGED_ATTR_URI.toString();
    }

    SharedContext(SharedContext copyContext) throws IdASException {
        ArrayList copyNodeList = copyContext.getNodeList();
        this._bLocked = false;
        this._szFileName = copyContext.getFileName();
        this._file = new File(this._szFileName);
        this._initPresetAttrs();
        this._lLastModifiedTime = copyContext.getLastModifiedTime();
        this._nodeMap = new HashMap();
        this._nodeList = new ArrayList();
        for (int iLoop = 0; iLoop < copyNodeList.size(); ++iLoop) {
            this.copyNode((SharedNode)copyNodeList.get(iLoop));
        }
    }

    void copyNode(SharedNode copyNode) throws IdASException {
        ArrayList attrList = copyNode.getAttrList();
        String szNodeID = copyNode.getNodeID();
        SharedNode sharedNode = new SharedNode(this, copyNode.getNodeType(), szNodeID);
        this._nodeMap.put(szNodeID, sharedNode);
        this._nodeList.add(sharedNode);
        for (int iLoop = 0; iLoop < attrList.size(); ++iLoop) {
            sharedNode.copyAttr((SharedAttribute)attrList.get(iLoop));
        }
    }

    String getFileName() {
        return this._szFileName;
    }

    ArrayList getNodeList() {
        return this._nodeList;
    }

    Map getNodeMap() {
        return this._nodeMap;
    }

    int getOpenCount() {
        return this._iOpenCount;
    }

    void setOpenCount(int iOpenCount) {
        this._iOpenCount = iOpenCount;
    }

    void incrOpenCount() {
        ++this._iOpenCount;
    }

    void decrOpenCount() {
        --this._iOpenCount;
    }

    long getLastCloseTime() {
        return this._lLastCloseTime;
    }

    void setLastCloseTime(long lLastCloseTime) {
        this._lLastCloseTime = lLastCloseTime;
    }

    private void _createFile() throws IdASException {
        org.w3c.dom.Document doc;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.newDocument();
            Element rootElement = doc.createElement(XML_CONTEXT_ELEMENT);
            doc.appendChild(rootElement);
        }
        catch (Exception e) {
            String szErrMsg = "Error creating XML DOM: " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        this._writeXMLDocument(doc);
        this._lLastModifiedTime = this._file.lastModified();
    }

    private void _writeXMLDocument(org.w3c.dom.Document doc) throws IdASException {
        File tmpFileName;
        File renameFileTo;
        File fileName;
        Document dom4jDoc;
        String szTmpFileName = null;
        String szRenameFileTo = null;
        try {
            DOMReader reader = new DOMReader();
            dom4jDoc = reader.read(doc);
        }
        catch (Exception e) {
            String szErrMsg = "Error getting DOMReader object: " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        try {
            fileName = new File(this._szFileName);
            File fileDir = fileName.getParentFile();
            renameFileTo = new File(fileDir, fileName.getName() + ".save");
            szRenameFileTo = renameFileTo.getCanonicalPath();
            tmpFileName = File.createTempFile("tmp_", ".xml", fileDir);
            szTmpFileName = tmpFileName.getCanonicalPath();
        }
        catch (IOException e) {
            String szErrMsg = "Error getting temporary and/or rename file names: " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        try {
            FileWriter fileWriter = new FileWriter(szTmpFileName);
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setIndent("\t");
            XMLWriter writer = new XMLWriter((Writer)fileWriter, outputFormat);
            writer.write(dom4jDoc);
            writer.close();
        }
        catch (Exception e) {
            String szErrMsg = "Error writing DOM to file '" + szTmpFileName + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        try {
            if (renameFileTo.exists()) {
                renameFileTo.delete();
            }
        }
        catch (Exception e) {
            String szErrMsg = "Error deleting old version of XML file '" + szRenameFileTo + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        try {
            if (fileName.exists() && !fileName.renameTo(renameFileTo)) {
                String szErrMsg = "Could not rename '" + this._szFileName + "' to '" + szRenameFileTo + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
        }
        catch (IdASException e1) {
            throw e1;
        }
        catch (SecurityException e2) {
            String szErrMsg = "Error renaming '" + this._szFileName + "' to '" + szRenameFileTo + "': " + e2.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        try {
            if (!tmpFileName.renameTo(fileName)) {
                renameFileTo.renameTo(fileName);
                throw new IdASException("Could not rename '" + this._szFileName + "' to '" + this._szFileName + "'");
            }
        }
        catch (IdASException e1) {
            throw e1;
        }
        catch (SecurityException e3) {
            String szErrMsg = "Error renaming '" + szTmpFileName + "' to '" + this._szFileName + "': " + e3.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
    }

    private String _getNodeText(Node node) {
        Node textNode;
        for (textNode = node.getFirstChild(); textNode != null && textNode.getNodeType() != 3; textNode = textNode.getNextSibling()) {
        }
        if (textNode != null) {
            return textNode.getNodeValue();
        }
        return null;
    }

    private boolean _isElementNode(Node node, String szElementName) {
        String szNodeElementName;
        return node.getNodeType() == 1 && (szNodeElementName = node.getLocalName()) != null && szNodeElementName.equals(szElementName);
    }

    private String _getElementAttr(Element element, String szXmlAttrName) throws IdASException {
        String szAttrValue = null;
        try {
            Attr attrNode = element.getAttributeNode(szXmlAttrName);
            if (attrNode != null) {
                szAttrValue = attrNode.getValue();
            }
        }
        catch (Exception e) {
            throw new IdASException("Error getting XML attribute '" + szXmlAttrName + "' for element: " + e.getMessage());
        }
        return szAttrValue;
    }

    private SharedAttributeValue _parseComplexAttributeValue(SharedAttribute sharedAttr, Node attrValueNode, String szAttrID) throws IdASException {
        SharedComplexAttrValue complexValue = new SharedComplexAttrValue(sharedAttr);
        for (Node attrNode = attrValueNode.getFirstChild(); attrNode != null; attrNode = attrNode.getNextSibling()) {
            if (!this._isElementNode(attrNode, XML_ATTRIBUTE_ELEMENT)) continue;
            SharedAttribute valueSharedAttr = this._parseAttribute(complexValue, attrNode);
            complexValue.addAttr(valueSharedAttr);
        }
        return complexValue;
    }

    private SharedAttribute _parseAttribute(SharedAttrContainer sharedContainer, Node attrNode) throws IdASException {
        String szAttrID = this._getElementAttr((Element)attrNode, XML_ATTR_ID_ATTR);
        String szAttrDataType = this._getElementAttr((Element)attrNode, XML_DATA_TYPE_ATTR);
        boolean bIsSimpleDataType = false;
        if (szAttrID == null) {
            String szErrMsg = "No AttrID attribute defined for attribute element in file " + this._szFileName + "'";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        if (szAttrDataType != null) {
            bIsSimpleDataType = NonsharedContextFactory.isSimpleDataType(szAttrDataType);
        }
        SharedAttribute sharedAttr = new SharedAttribute(sharedContainer, szAttrID, szAttrDataType, bIsSimpleDataType);
        for (Node attrValueNode = attrNode.getFirstChild(); attrValueNode != null; attrValueNode = attrValueNode.getNextSibling()) {
            SharedAttributeValue sharedAttrValue;
            if (!this._isElementNode(attrValueNode, XML_ATTRIBUTE_VALUE_ELEMENT)) continue;
            if (szAttrDataType == null) {
                String szErrMsg = "Type not set for attribute '" + szAttrID + "', type must be set when attribute has values, file: '" + this._szFileName + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            SharedAttributeValue sharedAttributeValue = sharedAttrValue = bIsSimpleDataType ? new SharedSimpleAttrValue(sharedAttr, this._getNodeText(attrValueNode)) : this._parseComplexAttributeValue(sharedAttr, attrValueNode, szAttrID);
            if (sharedAttr.findAttrValue(sharedAttrValue) != -1) {
                String szErrMsg = "Value for attribute '" + szAttrID + "' defined multiple times on Node in file '" + this._szFileName + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            sharedAttr.addValueToList(sharedAttrValue);
        }
        return sharedAttr;
    }

    private SharedNode _parseNode(Node nodeDOMNode, String szUserNameAttr) throws IdASException {
        String szNodeID = null;
        String szNodeType = this._getElementAttr((Element)nodeDOMNode, XML_NODE_TYPE_ATTR);
        if (szNodeType == null) {
            String szErrMsg = "Node type XML attribute 'NodeType' missing on XML element file " + this._szFileName + "'";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        SharedNode sharedNode = new SharedNode(this, szNodeType, null);
        for (Node attrNode = nodeDOMNode.getFirstChild(); attrNode != null; attrNode = attrNode.getNextSibling()) {
            if (!this._isElementNode(attrNode, XML_ATTRIBUTE_ELEMENT)) continue;
            SharedAttribute sharedAttr = this._parseAttribute(sharedNode, attrNode);
            sharedNode.addAttr(sharedAttr);
            String szAttrID = sharedAttr.getAttrID();
            if (!szAttrID.equals(this._szUserNameAttr)) continue;
            ArrayList valueList = sharedAttr.getValueList();
            if (sharedAttr.getAttrDataType() == null || valueList.size() == 0) {
                String szErrMsg = "No value defined for node ID attribute '" + szAttrID + "' on Node in file " + this._szFileName + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            if (!sharedAttr.isSimpleDataType()) {
                String szErrMsg = "Value for node ID attribute '" + szAttrID + "' on Node in file " + this._szFileName + "' is NOT a simple type";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            if (valueList.size() > 1) {
                String szErrMsg = "Multiple value for node ID attribute '" + szAttrID + "' on Node in file " + this._szFileName + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            szNodeID = ((SharedSimpleAttrValue)valueList.get(0)).getCanonical();
        }
        if (szNodeID == null) {
            String szErrMsg = "No " + this._szUserNameAttr + " defined for Node in file " + this._szFileName + "'";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        sharedNode.setNodeID(szNodeID);
        return sharedNode;
    }

    private void _parseFileToDOM() throws IdASException {
        HashMap<String, SharedNode> nodeMap = new HashMap<String, SharedNode>();
        ArrayList<SharedNode> nodeList = new ArrayList<SharedNode>();
        try {
            FileInputStream inputStream = new FileInputStream(new File(this._szFileName));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            org.w3c.dom.Document doc = documentBuilder.parse(inputStream);
            Element root = doc.getDocumentElement();
        }
        catch (Exception e) {
            String szErrMsg = "Error parsing DOM from file '" + this._szFileName + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!this._isElementNode(node, XML_NODE_ELEMENT)) continue;
            SharedNode sharedNode = this._parseNode(node, this._szUserNameAttr);
            String szNodeID = sharedNode.getNodeID();
            if (nodeMap.get(szNodeID) != null) {
                String szErrMsg = "Node '" + szNodeID + "' defined multiple times in file '" + this._szFileName + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            nodeMap.put(szNodeID, sharedNode);
            nodeList.add(sharedNode);
        }
        this._nodeMap = nodeMap;
        this._nodeList = nodeList;
        this._lLastModifiedTime = this._file.lastModified();
    }

    public void close() {
        this._nodeMap = null;
        this._nodeList = null;
        this._szFileName = null;
        this._file = null;
        this._szUserNameAttr = null;
        this._szPasswordAttr = null;
        this._szCardKeyHashAttr = null;
        this._log = null;
    }

    public long getLastModifiedTime() {
        return this._lLastModifiedTime;
    }

    boolean syncFile() throws IdASException {
        if (this._lLastModifiedTime != this._file.lastModified()) {
            this._parseFileToDOM();
            return true;
        }
        return false;
    }

    public synchronized void lock() {
        while (this._bLocked) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this._bLocked = true;
    }

    public synchronized void unlock() {
        this._bLocked = false;
        this.notify();
    }

    private int compareBigDecimalToLong(BigDecimal value1, long value2) {
        return value1.compareTo(BigDecimal.valueOf(value2));
    }

    private int compareBigDecimalToDouble(BigDecimal value1, double value2) {
        return value1.compareTo(new BigDecimal(value2));
    }

    private int compareBigDecimalToBigInteger(BigDecimal value1, BigInteger value2) {
        return value1.compareTo(new BigDecimal(value2));
    }

    private int compareBigIntegerToLong(BigInteger value1, long value2) {
        return value1.compareTo(BigInteger.valueOf(value2));
    }

    private int compareBigIntegerToDouble(BigInteger value1, double value2) {
        BigDecimal v1 = new BigDecimal(value1);
        return v1.compareTo(new BigDecimal(value2));
    }

    private int compareBigIntegerToBigDecimal(BigInteger value1, BigDecimal value2) {
        BigDecimal v1 = new BigDecimal(value1);
        return v1.compareTo(value2);
    }

    private int compareLongToBigDecimal(long value1, BigDecimal value2) {
        BigDecimal v1 = BigDecimal.valueOf(value1);
        return v1.compareTo(value2);
    }

    private int compareDoubleToBigDecimal(double value1, BigDecimal value2) {
        BigDecimal v1 = new BigDecimal(value1);
        return v1.compareTo(value2);
    }

    private int compareDoubleToBigInteger(double value1, BigInteger value2) {
        BigDecimal v1 = new BigDecimal(value1);
        return v1.compareTo(new BigDecimal(value2));
    }

    private int compareLongToBigInteger(long value1, BigInteger value2) {
        BigInteger v1 = BigInteger.valueOf(value1);
        return v1.compareTo(value2);
    }

    int compareDoubles(double value1, double value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    int compareFloats(float value1, float value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    int compareLongs(long value1, long value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    int compareIntegers(int value1, int value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    int compareShorts(short value1, short value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    int compareBytes(byte value1, byte value2) {
        if (value1 == value2) {
            return 0;
        }
        return value1 < value2 ? -1 : 1;
    }

    private Date _stringToDate(String szDate) throws IdASException {
        SimpleDateFormat sdf = new SimpleDateFormat();
        String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.S'Z'", "yyyy-MM-dd'T'HH:mm:ss'Z'", "yyyy-MM-dd'T'HH:mm:ss.SZ", "yyyy-MM-dd'T'HH:mm:ssZ"};
        Date date = null;
        for (int iFormat = 0; iFormat < formats.length; ++iFormat) {
            try {
                sdf.applyPattern(formats[iFormat]);
                date = sdf.parse(szDate);
                break;
            }
            catch (ParseException e) {
                date = null;
                continue;
            }
        }
        if (date == null) {
            throw new IdASException("Unable to parse date value: " + szDate);
        }
        return date;
    }

    private int compareDateToString(Date value1, String value2) throws Exception {
        return value1.compareTo(this._stringToDate(value2));
    }

    private int compareStringToDate(String value1, Date value2) throws Exception {
        Date v1 = this._stringToDate(value1);
        return v1.compareTo(value2);
    }

    private int compareDateToLong(Date value1, long value2) {
        return value1.compareTo(new Date(value2));
    }

    private int compareLongToDate(long value1, Date value2) {
        Date v1 = new Date(value1);
        return v1.compareTo(value2);
    }

    private int compareStringToUri(String value1, URI value2) throws Exception {
        URI v1 = new URI(value1);
        return v1.compareTo((Object)value2);
    }

    private int compareUriToString(URI value1, String value2) throws Exception {
        return value1.compareTo((Object)new URI(value2));
    }

    int compareSimpleObjects(Object obj1, Object obj2) throws IdASException {
        try {
            if (obj1 instanceof String) {
                if (obj2 instanceof String) {
                    return ((String)obj1).compareTo((String)obj2);
                }
                if (obj2 instanceof Boolean) {
                    return ((String)obj1).compareTo(((Boolean)obj2).toString());
                }
                if (obj2 instanceof BigDecimal) {
                    return ((String)obj1).compareTo(((BigDecimal)obj2).toString());
                }
                if (obj2 instanceof BigInteger) {
                    return ((String)obj1).compareTo(((BigInteger)obj2).toString());
                }
                if (obj2 instanceof Float) {
                    return ((String)obj1).compareTo(((Float)obj2).toString());
                }
                if (obj2 instanceof Double) {
                    return ((String)obj1).compareTo(((Double)obj2).toString());
                }
                if (obj2 instanceof Long) {
                    return ((String)obj1).compareTo(((Long)obj2).toString());
                }
                if (obj2 instanceof Integer) {
                    return ((String)obj1).compareTo(((Integer)obj2).toString());
                }
                if (obj2 instanceof Short) {
                    return ((String)obj1).compareTo(((Short)obj2).toString());
                }
                if (obj2 instanceof Byte) {
                    return ((String)obj1).compareTo(((Byte)obj2).toString());
                }
                if (obj2 instanceof ByteBuffer) {
                    return ((String)obj1).compareTo(((ByteBuffer)obj2).toString());
                }
                if (obj2 instanceof Date) {
                    return this.compareStringToDate((String)obj1, (Date)obj2);
                }
                if (obj2 instanceof URI) {
                    return this.compareStringToUri((String)obj1, (URI)obj2);
                }
            } else if (obj1 instanceof Boolean) {
                if (obj2 instanceof String) {
                    return ((Boolean)obj1).toString().compareTo((String)obj2);
                }
                if (obj2 instanceof Boolean) {
                    boolean b2;
                    boolean b1 = (Boolean)obj1;
                    if (b1 == (b2 = ((Boolean)obj2).booleanValue())) {
                        return 0;
                    }
                    return b1 ? 1 : -1;
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareLongToBigDecimal((Boolean)obj1 != false ? 1L : 0L, (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareLongToBigInteger((Boolean)obj1 != false ? 1L : 0L, (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareFloats((Boolean)obj1 != false ? 1.0f : 0.0f, ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles((Boolean)obj1 != false ? 1.0 : 0.0, (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareLongs((Boolean)obj1 != false ? 1L : 0L, (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareIntegers((Boolean)obj1 != false ? 1 : 0, (Integer)obj2);
                }
                if (obj2 instanceof Short) {
                    return this.compareIntegers((Boolean)obj1 != false ? 1 : 0, ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareBytes((Boolean)obj1 != false ? (byte)1 : 0, (Byte)obj2);
                }
            } else if (obj1 instanceof BigDecimal) {
                if (obj2 instanceof String) {
                    return ((BigDecimal)obj1).compareTo(new BigDecimal((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    this.compareBigDecimalToLong((BigDecimal)obj1, (Boolean)obj2 != false ? 1L : 0L);
                } else {
                    if (obj2 instanceof BigDecimal) {
                        return ((BigDecimal)obj1).compareTo((BigDecimal)obj2);
                    }
                    if (obj2 instanceof BigInteger) {
                        return this.compareBigDecimalToBigInteger((BigDecimal)obj1, (BigInteger)obj2);
                    }
                    if (obj2 instanceof Float) {
                        return this.compareBigDecimalToDouble((BigDecimal)obj1, ((Float)obj2).floatValue());
                    }
                    if (obj2 instanceof Double) {
                        return this.compareBigDecimalToDouble((BigDecimal)obj1, (Double)obj2);
                    }
                    if (obj2 instanceof Long) {
                        return this.compareBigDecimalToLong((BigDecimal)obj1, (Long)obj2);
                    }
                    if (obj2 instanceof Integer) {
                        return this.compareBigDecimalToLong((BigDecimal)obj1, ((Integer)obj2).intValue());
                    }
                    if (obj2 instanceof Short) {
                        return this.compareBigDecimalToLong((BigDecimal)obj1, ((Short)obj2).shortValue());
                    }
                    if (obj2 instanceof Byte) {
                        return this.compareBigDecimalToLong((BigDecimal)obj1, ((Byte)obj2).byteValue());
                    }
                }
            } else if (obj1 instanceof BigInteger) {
                if (obj2 instanceof String) {
                    return ((BigInteger)obj1).compareTo(new BigInteger((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareBigIntegerToLong((BigInteger)obj1, (Boolean)obj2 != false ? 1L : 0L);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareBigIntegerToBigDecimal((BigInteger)obj1, (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return ((BigInteger)obj1).compareTo((BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareBigIntegerToDouble((BigInteger)obj1, ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareBigIntegerToDouble((BigInteger)obj1, (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareBigIntegerToLong((BigInteger)obj1, (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareBigIntegerToLong((BigInteger)obj1, ((Integer)obj2).intValue());
                }
                if (obj2 instanceof Short) {
                    return this.compareBigIntegerToLong((BigInteger)obj1, ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareBigIntegerToLong((BigInteger)obj1, ((Byte)obj2).byteValue());
                }
            } else if (obj1 instanceof Float) {
                if (obj2 instanceof String) {
                    return ((Float)obj1).compareTo(new Float((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareFloats(((Float)obj1).floatValue(), (Boolean)obj2 != false ? 1.0f : 0.0f);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareDoubleToBigDecimal(((Float)obj1).floatValue(), (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareDoubleToBigInteger(((Float)obj1).floatValue(), (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareFloats(((Float)obj1).floatValue(), ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles(((Float)obj1).floatValue(), (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareDoubles(((Float)obj1).floatValue(), ((Long)obj2).longValue());
                }
                if (obj2 instanceof Integer) {
                    return this.compareDoubles(((Float)obj1).floatValue(), ((Integer)obj2).intValue());
                }
                if (obj2 instanceof Short) {
                    return this.compareDoubles(((Float)obj1).floatValue(), ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareDoubles(((Float)obj1).floatValue(), ((Byte)obj2).byteValue());
                }
            } else if (obj1 instanceof Double) {
                if (obj2 instanceof String) {
                    return ((Double)obj1).compareTo(new Double((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareDoubles((Double)obj1, (Boolean)obj2 != false ? 1.0 : 0.0);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareDoubleToBigDecimal((Double)obj1, (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareDoubleToBigInteger((Double)obj1, (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareDoubles((Double)obj1, ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles((Double)obj1, (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareDoubles((Double)obj1, ((Long)obj2).longValue());
                }
                if (obj2 instanceof Integer) {
                    return this.compareDoubles((Double)obj1, ((Integer)obj2).intValue());
                }
                if (obj2 instanceof Short) {
                    return this.compareDoubles((Double)obj1, ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareDoubles((Double)obj1, ((Byte)obj2).byteValue());
                }
            } else if (obj1 instanceof Long) {
                if (obj2 instanceof String) {
                    return ((Long)obj1).compareTo(new Long((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareLongs((Long)obj1, (Boolean)obj2 != false ? 1L : 0L);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareLongToBigDecimal((Long)obj1, (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareLongToBigInteger((Long)obj1, (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareDoubles(((Long)obj1).longValue(), ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles(((Long)obj1).longValue(), (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareLongs((Long)obj1, (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareLongs((Long)obj1, ((Integer)obj2).intValue());
                }
                if (obj2 instanceof Short) {
                    return this.compareLongs((Long)obj1, ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareLongs((Long)obj1, ((Byte)obj2).byteValue());
                }
                if (obj2 instanceof Date) {
                    return this.compareLongToDate((Long)obj1, (Date)obj2);
                }
            } else if (obj1 instanceof Integer) {
                if (obj2 instanceof String) {
                    return ((Integer)obj1).compareTo(new Integer((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareIntegers((Integer)obj1, (Boolean)obj2 != false ? 1 : 0);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareLongToBigDecimal(((Integer)obj1).intValue(), (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareLongToBigInteger(((Integer)obj1).intValue(), (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareDoubles(((Integer)obj1).intValue(), ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles(((Integer)obj1).intValue(), (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareLongs(((Integer)obj1).intValue(), (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareIntegers((Integer)obj1, (Integer)obj2);
                }
                if (obj2 instanceof Short) {
                    return this.compareIntegers((Integer)obj1, ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareIntegers((Integer)obj1, ((Byte)obj2).byteValue());
                }
                if (obj2 instanceof Date) {
                    return this.compareLongToDate(((Integer)obj1).intValue(), (Date)obj2);
                }
            } else if (obj1 instanceof Short) {
                if (obj2 instanceof String) {
                    return ((Short)obj1).compareTo(new Short((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareShorts((Short)obj1, (Boolean)obj2 != false ? (short)1 : 0);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareLongToBigDecimal(((Short)obj1).shortValue(), (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareLongToBigInteger(((Short)obj1).shortValue(), (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareDoubles(((Short)obj1).shortValue(), ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles(((Short)obj1).shortValue(), (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareLongs(((Short)obj1).shortValue(), (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareIntegers(((Short)obj1).shortValue(), (Integer)obj2);
                }
                if (obj2 instanceof Short) {
                    return this.compareShorts((Short)obj1, (Short)obj2);
                }
                if (obj2 instanceof Byte) {
                    return this.compareShorts((Short)obj1, ((Byte)obj2).byteValue());
                }
                if (obj2 instanceof Date) {
                    return this.compareLongToDate(((Short)obj1).shortValue(), (Date)obj2);
                }
            } else if (obj1 instanceof Byte) {
                if (obj2 instanceof String) {
                    return ((Byte)obj1).compareTo(new Byte((String)obj2));
                }
                if (obj2 instanceof Boolean) {
                    return this.compareBytes((Byte)obj1, (Boolean)obj2 != false ? (byte)1 : 0);
                }
                if (obj2 instanceof BigDecimal) {
                    return this.compareLongToBigDecimal(((Byte)obj1).byteValue(), (BigDecimal)obj2);
                }
                if (obj2 instanceof BigInteger) {
                    return this.compareLongToBigInteger(((Byte)obj1).byteValue(), (BigInteger)obj2);
                }
                if (obj2 instanceof Float) {
                    return this.compareDoubles(((Byte)obj1).byteValue(), ((Float)obj2).floatValue());
                }
                if (obj2 instanceof Double) {
                    return this.compareDoubles(((Byte)obj1).byteValue(), (Double)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareLongs(((Byte)obj1).byteValue(), (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareIntegers(((Byte)obj1).byteValue(), (Integer)obj2);
                }
                if (obj2 instanceof Short) {
                    return this.compareShorts(((Byte)obj1).byteValue(), (Short)obj2);
                }
                if (obj2 instanceof Byte) {
                    return this.compareBytes((Byte)obj1, (Byte)obj2);
                }
                if (obj2 instanceof Date) {
                    return this.compareLongToDate(((Byte)obj1).byteValue(), (Date)obj2);
                }
            } else if (obj1 instanceof ByteBuffer) {
                if (obj2 instanceof ByteBuffer) {
                    return ((ByteBuffer)obj1).compareTo((Object)((ByteBuffer)obj2));
                }
            } else if (obj1 instanceof Date) {
                if (obj2 instanceof String) {
                    return this.compareDateToString((Date)obj1, (String)obj2);
                }
                if (obj2 instanceof Long) {
                    return this.compareDateToLong((Date)obj1, (Long)obj2);
                }
                if (obj2 instanceof Integer) {
                    return this.compareDateToLong((Date)obj1, ((Integer)obj2).intValue());
                }
                if (obj2 instanceof Short) {
                    return this.compareDateToLong((Date)obj1, ((Short)obj2).shortValue());
                }
                if (obj2 instanceof Byte) {
                    return this.compareDateToLong((Date)obj1, ((Byte)obj2).byteValue());
                }
                if (obj2 instanceof Date) {
                    return ((Date)obj1).compareTo((Date)obj2);
                }
            } else if (obj1 instanceof URI) {
                if (obj2 instanceof String) {
                    return this.compareUriToString((URI)obj1, (String)obj2);
                }
                if (obj2 instanceof URI) {
                    return ((URI)obj1).compareTo((Object)((URI)obj2));
                }
            }
        }
        catch (Exception e) {
            String szErrMsg = "Error comparing value " + obj1.getClass().getName() + "={" + obj1.toString() + "} to value " + obj2.getClass().getName() + "={" + obj2.toString() + "}: " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        String szErrMsg = "Cannot compare value " + obj1.getClass().getName() + "={" + obj1.toString() + "} to value " + obj2.getClass().getName() + "={" + obj2.toString() + "}";
        this._log.debug((Object)szErrMsg);
        throw new IdASException(szErrMsg);
    }

    boolean testNode(SharedNode sharedNode, IFilter filter) throws IdASException {
        if (filter == null) {
            return true;
        }
        String szOperator = ((BasicFilter)filter).getOperator();
        BasicFilterAssertion assertion = (BasicFilterAssertion)((BasicFilter)filter).getAssertion();
        if (assertion == null) {
            boolean bAndOp = szOperator != null && szOperator.equals("urn:eclipse.higgins.idas.OP_AND");
            Iterator filterIter = ((BasicFilter)filter).getFilters();
            while (filterIter.hasNext()) {
                boolean bPassed = this.testNode(sharedNode, (IFilter)filterIter.next());
                if (!bPassed && bAndOp) {
                    return false;
                }
                if (!bPassed || bAndOp) continue;
                return true;
            }
            return false;
        }
        boolean bNotted = szOperator != null && szOperator.equals("urn:eclipse.higgins.idas.OP_NOT");
        String szAttrID = assertion.getID().toString();
        SharedAttribute sharedAttr = sharedNode.getAttribute(szAttrID);
        String szComparator = assertion.getComparator();
        if (!(assertion instanceof BasicFilterAttributeAssertion)) {
            throw new NotImplementedException("Only attribute assertions supported");
        }
        BasicFilterAttributeAssertion attributeAssertion = (BasicFilterAttributeAssertion)assertion;
        IAttributeValue assertionValue = attributeAssertion.getAssertionValue();
        if (assertionValue == null) {
            if (!szComparator.equals("urn:org.eclipse.higgins.idas.api.comparator.attribute.present")) {
                String szErrMsg = "Comparison operator '" + szComparator + "' not supported when no assertion value is given.";
                this._log.debug((Object)szErrMsg);
                throw new NotImplementedException(szErrMsg);
            }
            boolean bPassed = bNotted ? sharedAttr == null : sharedAttr != null;
            return bPassed;
        }
        if (!assertionValue.isSimple()) {
            throw new NotImplementedException("Complex assertion values in filters not supported.");
        }
        if (sharedAttr == null) {
            return false;
        }
        if (sharedAttr.getAttrDataType() == null || !sharedAttr.isSimpleDataType()) {
            return false;
        }
        if (szComparator.equals("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality")) {
            int iFoundIndex = sharedAttr.findAttrValue(assertionValue);
            if (bNotted) {
                return iFoundIndex == -1;
            }
            return iFoundIndex != -1;
        }
        if (!szComparator.equals("urn:org.eclipse.higgins.idas.api.comparator.attribute.greaterOrEqual") && !szComparator.equals("urn:org.eclipse.higgins.idas.api.comparator.attribute.lessOrEqual")) {
            String szErrMsg = "Comparison operator '" + szComparator + "' not supported.";
            this._log.debug((Object)szErrMsg);
            throw new NotImplementedException(szErrMsg);
        }
        boolean bGE = szComparator.equals("urn:org.eclipse.higgins.idas.api.comparator.attribute.greaterOrEqual");
        ArrayList attrList = sharedAttr.getValueList();
        for (int iLoop = 0; iLoop < attrList.size(); ++iLoop) {
            SharedAttributeValue sharedAttrValue = (SharedAttributeValue)attrList.get(iLoop);
            int iCmp = ((SharedSimpleAttrValue)sharedAttrValue).getData() != null ? this.compareSimpleObjects(((SharedSimpleAttrValue)sharedAttrValue).getData(), ((ISimpleAttrValue)assertionValue).getData()) : -1;
            if (bNotted) {
                if ((!bGE || iCmp >= 0) && (bGE || iCmp <= 0)) continue;
                return false;
            }
            if ((!bGE || iCmp < 0) && (bGE || iCmp > 0)) continue;
            return true;
        }
        return bNotted;
    }

    private SharedNode _findNode(String szSimpleValue, String szAttrID) throws IdASException {
        for (int iLoop = 0; iLoop < this._nodeList.size(); ++iLoop) {
            SharedNode sharedNode = (SharedNode)this._nodeList.get(iLoop);
            SharedAttribute sharedAttr = (SharedAttribute)sharedNode.getAttrMap().get(szAttrID);
            if (sharedAttr == null || sharedAttr.getAttrDataType() == null || !sharedAttr.isSimpleDataType()) continue;
            ArrayList valueList = sharedAttr.getValueList();
            for (int iLoop2 = 0; iLoop2 < valueList.size(); ++iLoop2) {
                SharedSimpleAttrValue simpleValue = (SharedSimpleAttrValue)valueList.get(iLoop2);
                if (simpleValue.getCanonical() == null || !szSimpleValue.equals(simpleValue.getCanonical())) continue;
                return sharedNode;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    String open(Object identity) throws IdASException {
        void var2_2;
        String szNodeID;
        if (identity instanceof AuthNAnonymousMaterials) {
            szNodeID = "";
        } else if (identity instanceof AuthNNamePasswordMaterials) {
            SharedSimpleAttrValue simpleValue;
            szNodeID = ((AuthNNamePasswordMaterials)identity).getUsername();
            SharedNode sharedNode = (SharedNode)this._nodeMap.get(szNodeID);
            if (sharedNode == null) {
                String szErrMsg = "Could not authenticate node '" + szNodeID + "', node not found";
                this._log.debug((Object)szErrMsg);
                throw new NoSuchNodeException("Could not authenticate node '" + szNodeID + "'");
            }
            SharedAttribute passwordAttr = sharedNode.getAttribute(this._szPasswordAttr);
            if (passwordAttr == null) {
                String szErrMsg = "No password attribute '" + this._szPasswordAttr + "' found on Node '" + szNodeID + "'";
                this._log.debug((Object)szErrMsg);
                throw new AuthenticationException("Could not authenticate node '" + szNodeID + "'");
            }
            if (passwordAttr.getAttrDataType() == null) {
                String szErrMsg = "Type for password attribute '" + this._szPasswordAttr + "' on Node '" + szNodeID + "' is not known, attribute has no values";
                this._log.debug((Object)szErrMsg);
                throw new AuthenticationException("Could not authenticate node '" + szNodeID + "'");
            }
            if (!passwordAttr.isSimpleDataType()) {
                String szErrMsg = "Password attribute '" + this._szPasswordAttr + "' on Node '" + szNodeID + "' is not a simple type";
                this._log.debug((Object)szErrMsg);
                throw new AuthenticationException("Could not authenticate node '" + szNodeID + "'");
            }
            ArrayList valueList = passwordAttr.getValueList();
            for (int iLoop = 0; !(iLoop >= valueList.size() || (simpleValue = (SharedSimpleAttrValue)valueList.get(iLoop)).getCanonical() != null && simpleValue.getCanonical().equals(((AuthNNamePasswordMaterials)identity).getPassword())); ++iLoop) {
                if (iLoop != valueList.size() - 1) continue;
                String szErrMsg = "Password value does not match password on for node '" + szNodeID + "'";
                this._log.debug((Object)szErrMsg);
                throw new AuthenticationException("Could not authenticate node '" + szNodeID + "'");
            }
        } else if (identity instanceof AuthNSelfIssuedMaterials) {
            BasicValueBase64Binary base64Value = null;
            try {
                ByteArrayOutputStream cardKey = new ByteArrayOutputStream();
                cardKey.write(((AuthNSelfIssuedMaterials)identity).getPPIDBytes());
                cardKey.write(((AuthNSelfIssuedMaterials)identity).getPublicKeyModBytes());
                cardKey.write(((AuthNSelfIssuedMaterials)identity).getPublicKeyExpBytes());
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                base64Value = new BasicValueBase64Binary(md.digest(cardKey.toByteArray()), null);
            }
            catch (Exception e) {
                String szErrMsg = "Error reading Node for card key hash, identity: " + identity.toString() + ", error: " + e.getMessage();
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            SharedNode sharedNode = this._findNode(base64Value.getCanonical(), this._szCardKeyHashAttr);
            if (sharedNode == null) {
                String szErrMsg = "AuthN materials produced no Node ID, hash='" + base64Value.getCanonical() + "'";
                this._log.debug((Object)szErrMsg);
                throw new NoSuchNodeException(szErrMsg);
            }
            SharedAttribute userNameAttr = sharedNode.getAttribute(this._szUserNameAttr);
            if (userNameAttr == null) {
                String szErrMsg = "No user name attribute specified on Node that was found, hash='" + base64Value.getCanonical() + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            if (!userNameAttr.isSimpleDataType()) {
                String szErrMsg = "User name attribute on Node that was found is not a simple type, hash='" + base64Value.getCanonical() + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            if (userNameAttr.getValueList().size() != 1) {
                String szErrMsg = "User name attribute on Node that was found is not single valued, hash='" + base64Value.getCanonical() + "'";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            szNodeID = ((SharedSimpleAttrValue)userNameAttr.getValueList().get(0)).getCanonical();
        } else {
            String szErrMsg = "Unsupported AuthN materials: " + identity.toString();
            this._log.debug((Object)szErrMsg);
            throw new NotImplementedException(szErrMsg);
        }
        return var2_2;
    }

    SharedNode getNode(String szNodeID) throws IdASException {
        SharedNode sharedNode = (SharedNode)this._nodeMap.get(szNodeID);
        if (sharedNode == null) {
            String szErrMsg = "sharedContext:getNode(nodeID): No such node '" + szNodeID + "'";
            this._log.debug((Object)szErrMsg);
            throw new NoSuchNodeException(szErrMsg);
        }
        return sharedNode;
    }

    void removeNode(String szNodeID) throws IdASException {
        try {
            SharedNode sharedNode = (SharedNode)this._nodeMap.remove(szNodeID);
            if (sharedNode == null) {
                String szErrMsg = "sharedContext:removeNode(nodeID): No such node '" + szNodeID + "'";
                this._log.debug((Object)szErrMsg);
                throw new NoSuchNodeException(szErrMsg);
            }
            sharedNode.setDeleted();
            for (int iLoop = 0; iLoop < this._nodeList.size(); ++iLoop) {
                if (sharedNode != (SharedNode)this._nodeList.get(iLoop)) continue;
                this._nodeList.remove(iLoop);
                break;
            }
        }
        catch (Exception e) {
            String szErrMsg = "sharedContext:removeNode(nodeID): Error removing Node '" + szNodeID + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
    }

    SharedNode addNode(URI type, String szNodeID) throws IdASException {
        SharedNode sharedNode = (SharedNode)this._nodeMap.get(szNodeID);
        if (sharedNode != null) {
            String szErrMsg = "sharedContext:addNode(type,nodeID): Attempting to add a Node '" + szNodeID + "' that already exists";
            this._log.debug((Object)szErrMsg);
            throw new NodeExistsException(szErrMsg);
        }
        sharedNode = new SharedNode(this, type.toString(), szNodeID);
        SharedAttribute sharedAttr = new SharedAttribute(sharedNode, this._szUserNameAttr, "http://www.w3.org/2001/XMLSchema#string", true);
        sharedAttr.addValueToList(new SharedSimpleAttrValue(sharedAttr, szNodeID));
        sharedNode.addAttr(sharedAttr);
        this._nodeMap.put(szNodeID, sharedNode);
        this._nodeList.add(sharedNode);
        return sharedNode;
    }

    SharedNode addNode(INode copyFrom) throws IdASException, NodeExistsException {
        SharedNode sharedNode = null;
        sharedNode = this.addNode(copyFrom.getNodeType(), copyFrom.getNodeID());
        Iterator attrIterator = copyFrom.getAttributes();
        while (attrIterator.hasNext()) {
            IAttribute attr = (IAttribute)attrIterator.next();
            sharedNode.addAttribute(attr);
        }
        return sharedNode;
    }

    private Element _createChildElement(org.w3c.dom.Document doc, Element parentElement, String szElementName, String szAttrName1, String szAttrValue1, String szAttrName2, String szAttrValue2, String szElementValue) {
        Element childElement = doc.createElement(szElementName);
        if (szElementValue != null) {
            childElement.appendChild(doc.createTextNode(szElementValue));
        }
        if (szAttrName1 != null && szAttrValue1 != null) {
            childElement.setAttribute(szAttrName1, szAttrValue1);
        }
        if (szAttrName2 != null && szAttrValue2 != null) {
            childElement.setAttribute(szAttrName2, szAttrValue2);
        }
        parentElement.appendChild(childElement);
        return childElement;
    }

    private void _createValueElements(org.w3c.dom.Document doc, Element attrElement, SharedAttribute sharedAttr) throws IdASException {
        ArrayList valueList = sharedAttr.getValueList();
        if (sharedAttr.getAttrDataType() != null) {
            boolean bIsSimpleDataType = sharedAttr.isSimpleDataType();
            for (int iLoop = 0; iLoop < valueList.size(); ++iLoop) {
                Element attrValueElement;
                if (bIsSimpleDataType) {
                    SharedSimpleAttrValue simpleValue = (SharedSimpleAttrValue)valueList.get(iLoop);
                    attrValueElement = this._createChildElement(doc, attrElement, XML_ATTRIBUTE_VALUE_ELEMENT, null, null, null, null, simpleValue.getCanonical());
                    continue;
                }
                SharedComplexAttrValue complexValue = (SharedComplexAttrValue)valueList.get(iLoop);
                attrValueElement = this._createChildElement(doc, attrElement, XML_ATTRIBUTE_VALUE_ELEMENT, null, null, null, null, null);
                this._createAttributeElements(doc, attrValueElement, complexValue);
            }
        }
    }

    private void _createAttributeElements(org.w3c.dom.Document doc, Element containerElement, SharedAttrContainer sharedContainer) throws IdASException {
        ArrayList attrList = sharedContainer.getAttrList();
        for (int iLoop = 0; iLoop < attrList.size(); ++iLoop) {
            SharedAttribute sharedAttr = (SharedAttribute)attrList.get(iLoop);
            Element attrElement = this._createChildElement(doc, containerElement, XML_ATTRIBUTE_ELEMENT, XML_ATTR_ID_ATTR, sharedAttr.getAttrID(), XML_DATA_TYPE_ATTR, sharedAttr.getAttrDataType(), null);
            this._createValueElements(doc, attrElement, sharedAttr);
        }
    }

    private void _createNodeElements(org.w3c.dom.Document doc, Element contextElement) throws IdASException {
        for (int iLoop = 0; iLoop < this._nodeList.size(); ++iLoop) {
            SharedNode sharedNode = (SharedNode)this._nodeList.get(iLoop);
            Element NodeElement = this._createChildElement(doc, contextElement, XML_NODE_ELEMENT, XML_NODE_TYPE_ATTR, sharedNode.getNodeType(), null, null, null);
            this._createAttributeElements(doc, NodeElement, sharedNode);
        }
    }

    void applyUpdates() throws IdASException {
        org.w3c.dom.Document doc;
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        this._log.debug((Object)"Applying updates ...");
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.newDocument();
            Element rootElement = doc.createElement(XML_CONTEXT_ELEMENT);
            doc.appendChild(rootElement);
            this._createNodeElements(doc, rootElement);
        }
        catch (IdASException e) {
            throw e;
        }
        catch (Exception e) {
            String szErrMsg = "sharedContext:applyUpdates(): Error creating XML DOM: " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        this._writeXMLDocument(doc);
        this._lLastModifiedTime = this._file.lastModified();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

