/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedComplexAttrValue;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedSimpleAttrValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttributeValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedComplexAttrValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedSimpleAttrValue;

public class ValueIterator
implements Iterator {
    private NonsharedAttribute _nonsharedAttr;
    private SharedAttribute _sharedAttr;
    private NonsharedAttrContainer _nonsharedAttrContainer;
    private NonsharedContext _nonsharedContext;
    private SharedAttributeValue _currSharedAttrValue;
    private int _iCurrValueNum;

    public ValueIterator(NonsharedAttribute attr) {
        this._nonsharedAttr = attr;
        this._sharedAttr = this._nonsharedAttr.getSharedAttribute();
        this._nonsharedAttrContainer = this._nonsharedAttr.getNonSharedAttrContainer();
        this._nonsharedContext = this._nonsharedAttrContainer.getNonSharedContext();
        this._currSharedAttrValue = null;
        this._iCurrValueNum = -1;
    }

    private boolean _syncValue(boolean bMustFindExact) throws IdASException {
        int iFoundNum = this._sharedAttr.findAttrValue(this._currSharedAttrValue);
        if (iFoundNum != -1) {
            this._currSharedAttrValue = (SharedAttributeValue)this._sharedAttr.getValueList().get(iFoundNum);
            this._iCurrValueNum = iFoundNum;
        } else {
            if (bMustFindExact) {
                return false;
            }
            --this._iCurrValueNum;
            if (this._iCurrValueNum >= 0 && this._iCurrValueNum < this._sharedAttr.getValueList().size()) {
                this._currSharedAttrValue = (SharedAttributeValue)this._sharedAttr.getValueList().get(this._iCurrValueNum);
            } else {
                this._nonsharedAttr = null;
                return false;
            }
        }
        return true;
    }

    private int _getNextValueNum() {
        boolean bSyncedAttr = false;
        try {
            int iNextValueNum;
            if (this._nonsharedAttr != null) {
                try {
                    bSyncedAttr = this._nonsharedAttr.sync(false);
                }
                catch (Exception e) {
                    this._nonsharedAttr = null;
                }
            }
            if (this._nonsharedAttr == null) {
                return -1;
            }
            if (bSyncedAttr) {
                this._sharedAttr = this._nonsharedAttr.getSharedAttribute();
                if (this._currSharedAttrValue != null && !this._syncValue(false)) {
                    return -1;
                }
            }
            if (this._currSharedAttrValue == null) {
                iNextValueNum = 0;
            } else {
                if (this._currSharedAttrValue.isDeleted() && !this._syncValue(false)) {
                    return -1;
                }
                iNextValueNum = this._iCurrValueNum + 1;
            }
            if (iNextValueNum >= this._sharedAttr.getValueList().size()) {
                return -1;
            }
            return iNextValueNum;
        }
        catch (IdASException idASException) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        int iNextValueNum = -1;
        if (!this._nonsharedContext.isOpen()) {
            return false;
        }
        try {
            this._nonsharedContext.lockSharedContext();
            iNextValueNum = this._getNextValueNum();
        }
        catch (IdASException e) {
            iNextValueNum = -1;
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        if (iNextValueNum == -1) {
            this._nonsharedAttr = null;
            return false;
        }
        return true;
    }

    public Object next() {
        Object attrValue = null;
        if (!this._nonsharedContext.isOpen()) {
            throw new NoSuchElementException();
        }
        try {
            this._nonsharedContext.lockSharedContext();
            int iNextValueNum = this._getNextValueNum();
            if (iNextValueNum == -1) {
                this._nonsharedAttr = null;
                this._currSharedAttrValue = null;
                throw new NoSuchElementException();
            }
            ArrayList valueList = this._sharedAttr.getValueList();
            this._currSharedAttrValue = (SharedAttributeValue)valueList.get(iNextValueNum);
            attrValue = this._sharedAttr.isSimpleDataType() ? new NonsharedSimpleAttrValue(this._nonsharedAttr, (SharedSimpleAttrValue)this._currSharedAttrValue) : new NonsharedComplexAttrValue(this._nonsharedAttr, (SharedComplexAttrValue)this._currSharedAttrValue);
            this._iCurrValueNum = iNextValueNum;
        }
        catch (IdASException e) {
            throw new NoSuchElementException("IdAS exception occurred: " + e.getMessage());
        }
        finally {
            this._nonsharedContext.unlockSharedContext();
        }
        return attrValue;
    }

    public void remove() {
        boolean bStartedTrans = false;
        if (!this._nonsharedContext.isOpen()) {
            throw new IllegalStateException("IdAS context is no longer open");
        }
        if (this._currSharedAttrValue == null || this._currSharedAttrValue.isDeleted()) {
            throw new IllegalStateException();
        }
        try {
            bStartedTrans = this._nonsharedContext.beginTrans();
            if (this._nonsharedAttr.sync(bStartedTrans)) {
                this._sharedAttr = this._nonsharedAttr.getSharedAttribute();
                if (!this._syncValue(true)) {
                    throw new NoSuchElementException();
                }
            }
            try {
                this._currSharedAttrValue.remove();
            }
            catch (IdASException e) {
                throw new NoSuchElementException();
            }
        }
        catch (IdASException e) {
            throw new IllegalStateException("IdAS exception occured: " + e.getMessage());
        }
        finally {
            if (!bStartedTrans) {
                this._nonsharedContext.unlockSharedContext();
            }
        }
    }
}

