/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.audit.api.AuditException;
import org.eclipse.higgins.audit.api.AuditRecord;
import org.eclipse.higgins.configuration.common.ConfigurableComponentFactoryHelper;
import org.eclipse.higgins.idas.api.ContextNotOpenException;
import org.eclipse.higgins.idas.api.ContextOpenException;
import org.eclipse.higgins.idas.api.EntityExistsException;
import org.eclipse.higgins.idas.api.IAuthNMaterials;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.UnhandledExtensionException;
import org.eclipse.higgins.idas.common.AuthNAnonymousMaterials;
import org.eclipse.higgins.idas.common.ForceReauthenticationExtension;
import org.eclipse.higgins.idas.cp.xmlfile.EntityIterator;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedEntity;
import org.eclipse.higgins.idas.cp.xmlfile.SharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedEntity;
import org.eclipse.higgins.idas.spi.BasicContext;

public class NonsharedContext
extends BasicContext {
    private Log _log;
    private Log _auditLog;
    private AuditRecord _auditRecord;
    private SharedContext _readOnlyContext;
    private SharedContext _updateContext;
    private String _szEntityID;
    private Object _identity;
    private int _iLockCount;
    private boolean _bIsOpen;
    private long _lLastModifiedTime;
    private long _lSyncCount;
    private IContextId _contextID;
    private String _contextURIs;
    private String _contextTypes;
    private Map _contextSettings;
    static /* synthetic */ Class class$0;

    public NonsharedContext(SharedContext readOnlyContext, IContextId contextID) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._auditLog = LogFactory.getLog((String)"higgins.audit.events");
        this._auditRecord = null;
        this._identity = null;
        this._iLockCount = 0;
        this._bIsOpen = false;
        this._lSyncCount = 0L;
        this._contextURIs = "";
        this._contextTypes = "";
        this._contextID = contextID;
        URI[] contextURIs = this._contextID.getUris();
        int iLoop = 0;
        while (iLoop < contextURIs.length) {
            this._contextURIs = String.valueOf(this._contextURIs) + contextURIs[iLoop].toString() + ", ";
            ++iLoop;
        }
        String[] contextTypes = this._contextID.getTypes();
        iLoop = 0;
        while (iLoop < contextTypes.length) {
            this._contextTypes = String.valueOf(this._contextTypes) + contextTypes[iLoop] + ", ";
            ++iLoop;
        }
        this._contextSettings = this._contextID.getConfiguration();
        this._readOnlyContext = readOnlyContext;
        this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
        this._updateContext = null;
        this._bIsOpen = false;
        this._iLockCount = 0;
        this._identity = null;
        this._szEntityID = null;
        String strAuditRecordClass = (String)this._contextSettings.get("AuditRecordClass");
        if (strAuditRecordClass != null) {
            try {
                this._auditRecord = (AuditRecord)ConfigurableComponentFactoryHelper.getInstanceFromClassName((String)strAuditRecordClass);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
    }

    long getSyncCount() {
        return this._lSyncCount;
    }

    boolean sync(boolean bForceSync) throws IdASException {
        boolean bSynced = false;
        if (this._updateContext != null) {
            bSynced = bForceSync;
        } else if (bForceSync || this._lLastModifiedTime != this._readOnlyContext.getLastModifiedTime()) {
            this._lLastModifiedTime = this._readOnlyContext.getLastModifiedTime();
            bSynced = true;
        }
        if (bSynced) {
            ++this._lSyncCount;
        }
        return bSynced;
    }

    void lockSharedContext() throws IdASException {
        if (this._iLockCount == 0) {
            this._readOnlyContext.lock();
            this._readOnlyContext.syncFile();
        }
        ++this._iLockCount;
    }

    void unlockSharedContext() {
        --this._iLockCount;
        if (this._iLockCount == 0) {
            this._readOnlyContext.unlock();
        }
    }

    public String open(IAuthNMaterials identity, IExtension[] extensions) throws IdASException, ContextOpenException {
        if (this.isOpen(null)) {
            throw new ContextOpenException();
        }
        if (extensions != null) {
            int index = 0;
            while (index < extensions.length) {
                if (extensions[index].failIfUnsupported() && !(extensions[index] instanceof ForceReauthenticationExtension)) {
                    throw new UnhandledExtensionException(String.valueOf(extensions[index].getClass().getName()) + " not supported");
                }
                ++index;
            }
        }
        return this.open(identity);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String open(IAuthNMaterials identity) throws IdASException {
        if (this._bIsOpen) {
            throw new ContextOpenException("nonsharedContext:open(): Context already open");
        }
        try {
            this.lockSharedContext();
            this._szEntityID = this._readOnlyContext.open(identity);
            this._bIsOpen = true;
            this._identity = identity instanceof AuthNAnonymousMaterials ? "[ANONYMOUS]" : identity;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this._emitAuditRecord(0x1000007, 0, this._identity.toString(), null, null);
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this._emitAuditRecord(0x1000007, 0, this._identity.toString(), null, null);
        this.unlockSharedContext();
        return this._szEntityID;
    }

    protected void finalize() {
        if (this._bIsOpen) {
            try {
                this.close();
            }
            catch (IdASException idASException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonSharedContext:close(): Context not open");
        }
        this._emitAuditRecord(0x1000008, 0, this._identity.toString(), null, null);
        this._log.debug((Object)("Context closed: " + this._contextURIs + " as: " + this._identity.toString()));
        if (this._readOnlyContext != null) {
            if (this._iLockCount > 0) {
                this._readOnlyContext.unlock();
                this._iLockCount = 0;
            }
            HashMap hashMap = NonsharedContextFactory.SharedContextTable;
            synchronized (hashMap) {
                this._readOnlyContext.decrOpenCount();
                this._readOnlyContext.setLastCloseTime(System.currentTimeMillis());
            }
            this._readOnlyContext = null;
        }
        this._bIsOpen = false;
        this._identity = null;
    }

    public boolean isOpen(Object identity) throws IdASException {
        return this._bIsOpen;
    }

    boolean isOpen() {
        return this._bIsOpen;
    }

    SharedContext getSharedContext() {
        return this._updateContext == null ? this._readOnlyContext : this._updateContext;
    }

    boolean beginTrans() throws IdASException {
        this.lockSharedContext();
        if (this._updateContext == null) {
            this._updateContext = new SharedContext(this._readOnlyContext);
            return true;
        }
        return false;
    }

    public String getSchema() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonSharedContext:getSchema()");
    }

    public IEntity getEntity(String szEntityID) throws IdASException {
        return this.getEntity(szEntityID, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEntity getEntity(String szEntityID, Iterator consumerSelectionList) throws IdASException {
        NonsharedEntity nonsharedEntity;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getEntity(entityID,attrList): Context not open");
        }
        try {
            this.lockSharedContext();
            sharedEntity = this.getSharedContext().getEntity(szEntityID);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.unlockSharedContext();
            if (sharedEntity == null) {
                return null;
            }
            nonsharedEntity = new NonsharedEntity(this, sharedEntity);
        }
        return nonsharedEntity;
    }

    public Iterator getEntities(IFilter filter) throws IdASException {
        return this.getEntities(filter, null);
    }

    public Iterator getEntities(IFilter filter, Iterator consumerSelectionList) throws IdASException {
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:getEntities(filter,attrlist): Context not open");
        }
        this._emitAuditRecord(0x1000005, 0, this._identity.toString(), filter == null ? null : filter.toString(), null);
        this._log.debug((Object)("Searching for Entities matching filter: " + (filter == null ? "[empty]" : filter.toString()) + " as: " + this._identity.toString() + " in context: " + this._contextURIs));
        return new EntityIterator(this, filter);
    }

    /*
     * Exception decompiling
     */
    public void removeEntity(String szEntityID) throws IdASException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 55->59)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEntity addEntity(URI type, String szEntityID) throws IdASException {
        NonsharedEntity nonsharedEntity;
        boolean bStartedTrans = false;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addEntity(type,entityID): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedEntity = this._updateContext.addEntity(type, szEntityID);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bStartedTrans) throw throwable;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var5_7 = null;
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
            if (sharedEntity == null) {
                return null;
            }
            nonsharedEntity = new NonsharedEntity(this, sharedEntity);
        }
        return nonsharedEntity;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IEntity addEntity(IEntity copyFrom) throws IdASException, EntityExistsException {
        NonsharedEntity nonsharedEntity;
        boolean bStartedTrans = false;
        SharedEntity sharedEntity = null;
        if (!this._bIsOpen) {
            throw new ContextNotOpenException("nonsharedContext:addEntity(copyFrom): Context not open");
        }
        try {
            bStartedTrans = this.beginTrans();
            sharedEntity = this._updateContext.addEntity(copyFrom);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (bStartedTrans) throw throwable;
            this.unlockSharedContext();
            throw throwable;
        }
        {
            Object var4_6 = null;
            if (!bStartedTrans) {
                this.unlockSharedContext();
            }
            if (sharedEntity == null) {
                return null;
            }
            nonsharedEntity = new NonsharedEntity(this, sharedEntity);
        }
        return nonsharedEntity;
    }

    public void applyUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext.applyUpdates();
            this._readOnlyContext.setDataFromContext(this._updateContext);
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    public void cancelUpdates() throws IdASException {
        if (this._updateContext != null) {
            this._updateContext = null;
            this.unlockSharedContext();
        }
    }

    private void _emitAuditRecord(int iEventNumber, int iOutcome, String sInitiatorInfo, String sTargetInfo, String sEventInfo) throws IdASException {
        if (this._auditRecord != null) {
            try {
                this._auditRecord.clearRecord();
                this._auditRecord.setOriginatorInfo("Higgins IdAS JNDI Context Provider", null, null, null, null, null);
                if (sTargetInfo == null) {
                    sTargetInfo = "";
                }
                if (sEventInfo == null) {
                    sEventInfo = "";
                }
                this._auditRecord.setEventNumber(iEventNumber);
                this._auditRecord.setOutcome(iOutcome);
                this._auditRecord.setInitiatorInfo(null, null, sInitiatorInfo);
                this._auditRecord.setTargetInfo(null, this._contextURIs, this._contextTypes, null, null, sTargetInfo);
                this._auditLog.info((Object)this._auditRecord);
            }
            catch (AuditException e) {
                throw new IdASException((Throwable)e);
            }
        }
    }
}

