/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.configuration.api.IConfigurableComponent;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextFactory;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.cp.xmlfile.NonsharedContext;
import org.eclipse.higgins.idas.cp.xmlfile.SharedContext;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;

public class NonsharedContextFactory
extends BasicAttributeSet
implements IContextFactory,
IConfigurableComponent {
    private ISettingDescriptor _contextFactoryDescriptor = null;
    private List _contextTypesList = null;
    private String _contextFactoryClassName = null;
    public static final String XML_FILENAME_SETTING = "XmlFileName";
    private Log _log;
    private static HashMap _SimpleDataTypes = null;
    static HashMap SharedContextTable = new HashMap();
    static /* synthetic */ Class class$0;

    public NonsharedContextFactory() throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.xmlfile.NonsharedContextFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        NonsharedContextFactory._initSimpleDataTypes();
    }

    public static boolean isSimpleDataType(String szDataType) {
        return _SimpleDataTypes.get(szDataType) != null;
    }

    private static synchronized void _initSimpleDataTypes() {
        if (_SimpleDataTypes == null) {
            _SimpleDataTypes = new HashMap();
            int iLoop = 0;
            while (iLoop < ITypedValue.typeMap.length) {
                String[] TypeClass = ITypedValue.typeMap[iLoop];
                _SimpleDataTypes.put(TypeClass[0], TypeClass[1]);
                ++iLoop;
            }
        }
    }

    public String getName() throws IdASException {
        return "Higgins XML File Context Provider";
    }

    public Iterator getContexts(String filter) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedContextFactory:getContexts(filter)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContext createContext(IContextId contextID) throws IdASException {
        SharedContext sharedCtx;
        Map contextSettings = contextID.getConfiguration();
        String szXmlFileName = (String)contextSettings.get(XML_FILENAME_SETTING);
        URI[] contextURIs = contextID.getUris();
        String szContextURIs = "";
        String[] contextTypes = contextID.getTypes();
        String szContextTypes = "";
        int iLoop = 0;
        while (iLoop < contextURIs.length) {
            if (iLoop > 0) {
                szContextURIs = String.valueOf(szContextURIs) + ", ";
            }
            szContextURIs = String.valueOf(szContextURIs) + contextURIs[iLoop].toString();
            ++iLoop;
        }
        iLoop = 0;
        while (iLoop < contextTypes.length) {
            if (iLoop > 0) {
                szContextTypes = String.valueOf(szContextTypes) + ", ";
            }
            szContextTypes = String.valueOf(szContextTypes) + contextTypes[iLoop];
            ++iLoop;
        }
        try {
            File tmpFile = new File(szXmlFileName);
            szXmlFileName = tmpFile.getCanonicalPath();
        }
        catch (Exception e) {
            String szErrMsg = "Error getting canonical path for file name '" + szXmlFileName + "': " + e.getMessage();
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        HashMap hashMap = SharedContextTable;
        synchronized (hashMap) {
            sharedCtx = (SharedContext)SharedContextTable.get(szXmlFileName);
            if (sharedCtx == null) {
                sharedCtx = new SharedContext(szXmlFileName);
                sharedCtx.setOpenCount(1);
                sharedCtx.setLastCloseTime(0L);
                SharedContextTable.put(szXmlFileName, sharedCtx);
            } else {
                sharedCtx.incrOpenCount();
            }
            Iterator contextIter = SharedContextTable.keySet().iterator();
            while (contextIter.hasNext()) {
                String szFileName = (String)contextIter.next();
                SharedContext tmpSharedCtx = (SharedContext)SharedContextTable.get(szFileName);
                if (tmpSharedCtx.getOpenCount() != 0 || tmpSharedCtx.getLastCloseTime() + 3600000L >= System.currentTimeMillis()) continue;
                tmpSharedCtx.close();
                SharedContextTable.remove(szFileName);
            }
        }
        return new NonsharedContext(sharedCtx, contextID);
    }

    public String getPolicy() throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedContextFactory:getPolicy()");
    }

    public void setPolicy(String arg0) throws IdASException {
        throw new NotImplementedException("Not Implemented: nonsharedContextFactory:setPolicy(arg0)");
    }

    public void configure(Map mapGlobalSettings, String szComponentName, Map mapComponentSettings) throws Exception {
    }

    public ISettingDescriptor getContextDescriptor(String contextIdName) throws IdASException {
        SettingDescriptor settingDescriptor = new SettingDescriptor(contextIdName, "htf:map");
        settingDescriptor.addSubSetting(XML_FILENAME_SETTING, "xsd:string");
        return settingDescriptor;
    }

    public ISettingDescriptor getComponentDescriptor() {
        return this._contextFactoryDescriptor;
    }

    public List getTypes() throws IdASException {
        return this._contextTypesList;
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, ISettingDescriptor componentDescriptor, ISettingDescriptor globalDescriptor) throws Exception {
        if (mapComponentSettings != null) {
            this._contextFactoryClassName = (String)mapComponentSettings.get("Instance");
            this._contextTypesList = (List)mapComponentSettings.get("ContextTypes");
        }
        this._contextFactoryDescriptor = componentDescriptor;
    }
}

