/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.api.model.ISimpleValueModel;
import org.eclipse.higgins.idas.api.model.IValueModel;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttributeValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedComplexAttrValue;
import org.eclipse.higgins.idas.cp.xmlfile.SharedSimpleAttrValue;
import org.eclipse.higgins.idas.spi.BasicContext;

public abstract class SharedAttrContainer {
    private Map _attrMap = new HashMap();
    private ArrayList _attrList = new ArrayList();

    SharedAttrContainer() {
    }

    abstract String getContainerID();

    abstract String getContainerType();

    abstract Log getLogger();

    ArrayList getAttrList() {
        return this._attrList;
    }

    Map getAttrMap() {
        return this._attrMap;
    }

    void copyAttr(SharedAttribute copyAttribute) throws IdASException {
        String szDataType;
        ArrayList valueList = copyAttribute.getValueList();
        String szAttrID = copyAttribute.getAttrID();
        SharedAttribute sharedAttr = new SharedAttribute(this, szAttrID, szDataType, (szDataType = copyAttribute.getAttrDataType()) != null ? copyAttribute.isSimpleDataType() : false);
        this._attrMap.put(szAttrID, sharedAttr);
        this._attrList.add(sharedAttr);
        int iLoop = 0;
        while (iLoop < valueList.size()) {
            sharedAttr.copyValue((SharedAttributeValue)valueList.get(iLoop));
            ++iLoop;
        }
    }

    SharedAttribute getAttribute(String szAttrID) throws IdASException {
        return (SharedAttribute)this._attrMap.get(szAttrID);
    }

    void addAttr(SharedAttribute sharedAttr) throws IdASException {
        if (this._attrMap.get(sharedAttr.getAttrID()) != null) {
            String szErrMsg = "Attribute '" + sharedAttr.getAttrID() + "' defined multiple times on value for " + this.getContainerType() + " '" + this.getContainerID() + "'";
            this.getLogger().debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        this._attrMap.put(sharedAttr.getAttrID(), sharedAttr);
        this._attrList.add(sharedAttr);
    }

    SharedAttribute getSingleValuedAttribute(String szAttrID) throws IdASException, NotSingleValuedAttributeException {
        SharedAttribute attr = (SharedAttribute)this._attrMap.get(szAttrID);
        if (attr != null && attr.getValueList().size() > 1) {
            String szErrMsg = "getSingleValuedAttribute: Attribute '" + szAttrID + "' on " + this.getContainerType() + " '" + this.getContainerID() + "' is NOT single-valued";
            this.getLogger().debug((Object)szErrMsg);
            throw new NotSingleValuedAttributeException(szErrMsg);
        }
        return attr;
    }

    SharedAttribute addAttribute(String szAttrID) throws IdASException, InvalidTypeException {
        SharedAttribute attr = null;
        attr = (SharedAttribute)this._attrMap.get(szAttrID);
        if (attr == null) {
            attr = new SharedAttribute(this, szAttrID, null, false);
            this._attrMap.put(szAttrID, attr);
            this._attrList.add(attr);
        }
        return attr;
    }

    SharedAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        IValue attrValue;
        Iterator valueIterator;
        boolean bIsSimpleDataType;
        String szAttrDataType;
        String szAttrID;
        SharedAttribute sharedAttr;
        block10: {
            sharedAttr = null;
            szAttrID = copyFrom.getType().toString();
            if (this._attrMap.get(szAttrID) != null) {
                String szErrMsg = "addAttribute(copyFrom): Attempting to add attribute ID '" + szAttrID + "' that already exists on " + this.getContainerType() + " '" + this.getContainerID() + "'";
                this.getLogger().debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            szAttrDataType = null;
            URI attrDataType = null;
            bIsSimpleDataType = false;
            valueIterator = copyFrom.getValues();
            if (valueIterator == null || !valueIterator.hasNext()) {
                try {
                    IValueModel attrValueModel;
                    IAttributeModel attrModel = copyFrom.getModel();
                    if (attrModel == null || (attrValueModel = attrModel.getValueModel()) == null) break block10;
                    attrDataType = attrValueModel.getType();
                    szAttrDataType = attrDataType.toString();
                    if (attrValueModel instanceof ISimpleValueModel) {
                        bIsSimpleDataType = true;
                    }
                }
                catch (NotImplementedException notImplementedException) {
                    szAttrDataType = null;
                }
            } else {
                attrValue = (IValue)valueIterator.next();
                attrDataType = attrValue.getType();
                szAttrDataType = attrDataType.toString();
                bIsSimpleDataType = attrValue.isSimple();
            }
        }
        sharedAttr = new SharedAttribute(this, szAttrID, szAttrDataType, bIsSimpleDataType);
        valueIterator = copyFrom.getValues();
        if (valueIterator != null) {
            while (valueIterator.hasNext()) {
                attrValue = (IValue)valueIterator.next();
                if (bIsSimpleDataType) {
                    sharedAttr.addValueToList(new SharedSimpleAttrValue(sharedAttr, ((ISimpleValue)attrValue).getData()));
                    continue;
                }
                Iterator attrIter = ((IEntity)attrValue).getAttributes();
                SharedComplexAttrValue complexAttrValue = new SharedComplexAttrValue(sharedAttr);
                while (attrIter.hasNext()) {
                    complexAttrValue.addAttribute((IAttribute)attrIter.next());
                }
                sharedAttr.addValueToList(complexAttrValue);
            }
        }
        this._attrMap.put(szAttrID, sharedAttr);
        this._attrList.add(sharedAttr);
        return sharedAttr;
    }

    void removeAttribute(String szAttrID) throws IdASException {
        SharedAttribute attr = (SharedAttribute)this._attrMap.remove(szAttrID);
        if (attr == null) {
            String szErrMsg = "removeAttribute: Could not find attribute '" + szAttrID + "' on " + this.getContainerType() + " '" + this.getContainerID() + "'";
            this.getLogger().debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        attr.setDeleted();
        int iLoop = 0;
        while (iLoop < this._attrList.size()) {
            if (attr == (SharedAttribute)this._attrList.get(iLoop)) {
                this._attrList.remove(iLoop);
                break;
            }
            ++iLoop;
        }
    }

    void removeAttributeValue(String szAttrID, Object value) throws IdASException {
        SharedAttribute sharedAttr = (SharedAttribute)this._attrMap.get(szAttrID);
        if (sharedAttr == null) {
            String szErrMsg = "removeAttributeValue(attrID,value): Could not find attribute '" + szAttrID + "' on " + this.getContainerType() + " '" + this.getContainerID() + "'";
            this.getLogger().debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        if (sharedAttr.getAttrDataType() != null) {
            if (!sharedAttr.isSimpleDataType()) {
                String szErrMsg = "removeAttributeValue(attrID,value): Type for values on attribute '" + szAttrID + "' on " + this.getContainerType() + " '" + this.getContainerID() + "' is NOT a simple type";
                this.getLogger().debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            ISimpleValue attrValue = BasicContext.createSimpleValue((URI)URI.create(sharedAttr.getAttrDataType()), (Object)value, null);
            int iFoundIndex = sharedAttr.findAttrValue((IValue)attrValue);
            if (iFoundIndex == -1) {
                String szErrMsg = "removeAttributeValue(attrID,value): Value on attribute '" + szAttrID + "' on " + this.getContainerType() + " '" + this.getContainerID() + "' not found";
                this.getLogger().debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            ArrayList valueList = sharedAttr.getValueList();
            SharedSimpleAttrValue simpleValue = (SharedSimpleAttrValue)valueList.get(iFoundIndex);
            simpleValue.setDeleted();
            valueList.remove(iFoundIndex);
        }
    }

    void removeAttributeValue(IAttribute attr) throws IdASException {
        String szAttrID = attr.getType().toString();
        SharedAttribute sharedAttr = (SharedAttribute)this._attrMap.get(szAttrID);
        if (sharedAttr == null) {
            String szErrMsg = "removeAttributeValue(attr): Could not find attribute '" + szAttrID + "' on " + this.getContainerType() + " '" + this.getContainerID() + "'";
            this.getLogger().debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        Iterator valueIterator = attr.getValues();
        if (valueIterator != null && sharedAttr.getAttrDataType() != null) {
            ArrayList valueList = sharedAttr.getValueList();
            while (valueIterator.hasNext()) {
                int iFoundIndex = sharedAttr.findAttrValue((IValue)valueIterator.next());
                if (iFoundIndex == -1) continue;
                SharedAttributeValue sharedAttrValue = (SharedAttributeValue)valueList.get(iFoundIndex);
                sharedAttrValue.setDeleted();
                valueList.remove(iFoundIndex);
            }
        }
    }

    boolean equals(IHasAttributes attributes) throws IdASException {
        SharedAttribute testValueAttr;
        Iterator attrIterator = attributes.getAttributes();
        HashMap<String, SharedAttribute> attrsMatchedMap = new HashMap<String, SharedAttribute>();
        while (attrIterator.hasNext()) {
            IAttribute attr = (IAttribute)attrIterator.next();
            String szAttrID = attr.getType().toString();
            testValueAttr = (SharedAttribute)this._attrMap.get(szAttrID);
            if (testValueAttr == null) {
                return false;
            }
            if (!testValueAttr.equals(attr)) {
                return false;
            }
            if (attrsMatchedMap.get(szAttrID) != null) {
                return false;
            }
            attrsMatchedMap.put(szAttrID, testValueAttr);
        }
        int iLoop = 0;
        while (iLoop < this._attrList.size()) {
            testValueAttr = (SharedAttribute)this._attrList.get(iLoop);
            SharedAttribute testValueAttr2 = (SharedAttribute)attrsMatchedMap.get(testValueAttr.getAttrID());
            if (testValueAttr2 == null || testValueAttr2 != testValueAttr) {
                return false;
            }
            ++iLoop;
        }
        return true;
    }

    public boolean equals(SharedAttributeValue testValue) throws IdASException {
        if (!(testValue instanceof SharedComplexAttrValue)) {
            return false;
        }
        return this.equals((SharedComplexAttrValue)testValue);
    }

    boolean equals(SharedAttrContainer testValue) throws IdASException {
        SharedAttribute testValueAttr;
        HashMap<String, SharedAttribute> attrsMatchedMap = new HashMap<String, SharedAttribute>();
        Map testValueAttrMap = testValue.getAttrMap();
        ArrayList testValueAttrList = testValue.getAttrList();
        int iLoop = 0;
        while (iLoop < this._attrList.size()) {
            SharedAttribute sharedAttr = (SharedAttribute)this._attrList.get(iLoop);
            String szAttrID = sharedAttr.getAttrID();
            testValueAttr = (SharedAttribute)testValueAttrMap.get(szAttrID);
            if (testValueAttr == null) {
                return false;
            }
            if (!testValueAttr.equals(sharedAttr)) {
                return false;
            }
            if (attrsMatchedMap.get(szAttrID) != null) {
                return false;
            }
            attrsMatchedMap.put(szAttrID, testValueAttr);
            ++iLoop;
        }
        iLoop = 0;
        while (iLoop < testValueAttrList.size()) {
            testValueAttr = (SharedAttribute)testValueAttrList.get(iLoop);
            SharedAttribute testValueAttr2 = (SharedAttribute)attrsMatchedMap.get(testValueAttr.getAttrID());
            if (testValueAttr2 == null || testValueAttr2 != testValueAttr) {
                return false;
            }
            ++iLoop;
        }
        return true;
    }
}

