/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.cp.xmlfile;

import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.ISimpleValue;
import org.eclipse.higgins.idas.api.IValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttrContainer;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttribute;
import org.eclipse.higgins.idas.cp.xmlfile.SharedAttributeValue;
import org.eclipse.higgins.idas.spi.BasicContext;

public class SharedSimpleAttrValue
implements SharedAttributeValue {
    private Log _log;
    private SharedAttribute _sharedAttr;
    private SharedAttrContainer _sharedAttrContainer;
    private Object _data;
    private String _szLexicalData;
    private String _szCanonicalData;
    private boolean _bDeleted;
    static /* synthetic */ Class class$0;

    SharedSimpleAttrValue(SharedAttribute sharedAttr, Object data) throws IdASException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.idas.cp.xmlfile.SharedSimpleAttrValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this._log = LogFactory.getLog((String)clazz.getName());
        this._bDeleted = false;
        this._sharedAttr = sharedAttr;
        this._sharedAttrContainer = this._sharedAttr.getSharedAttrContainer();
        this._setDataFields(data);
    }

    private void _setDataFields(Object data) throws IdASException {
        if (data == null) {
            this._data = null;
            this._szLexicalData = null;
            this._szCanonicalData = null;
        } else {
            if (this._sharedAttr.getAttrDataType() == null) {
                String szErrMsg = "sharedSimpleAttrValue:_setDataFields(data): Type for value on attribute '" + this._sharedAttr.getAttrID() + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "' not defined";
                this._log.debug((Object)szErrMsg);
                throw new IdASException(szErrMsg);
            }
            ISimpleValue attrSimpleValue = BasicContext.createSimpleValue((URI)URI.create(this._sharedAttr.getAttrDataType()), (Object)data, null);
            this._data = attrSimpleValue.getData();
            this._szLexicalData = attrSimpleValue.getLexical();
            this._szCanonicalData = attrSimpleValue.getCanonical();
        }
    }

    public void setDeleted() {
        this._bDeleted = true;
    }

    public boolean isDeleted() {
        return this._bDeleted;
    }

    public boolean isSimple() {
        return true;
    }

    public String getDataType() {
        return this._sharedAttr.getAttrDataType();
    }

    public void remove() throws IdASException {
        ArrayList valueList = this._sharedAttr.getValueList();
        int iLoop = 0;
        while (iLoop < valueList.size()) {
            if (this == (SharedSimpleAttrValue)valueList.get(iLoop)) {
                valueList.remove(iLoop);
                break;
            }
            ++iLoop;
        }
        this._bDeleted = true;
    }

    public boolean equals(IValue simpleValue) throws IdASException {
        if (this._sharedAttr.getAttrDataType() == null || !this._sharedAttr.getAttrDataType().equals(((ISimpleValue)simpleValue).getModel().getType().toString())) {
            return false;
        }
        if (!simpleValue.isSimple()) {
            return false;
        }
        if (this._data == null || ((ISimpleValue)simpleValue).getData() == null) {
            return false;
        }
        return ((ISimpleValue)simpleValue).getCanonical().equals(this._szCanonicalData);
    }

    public boolean equals(SharedAttributeValue attrValue) throws IdASException {
        if (!(attrValue instanceof SharedSimpleAttrValue)) {
            return false;
        }
        if (this._data == null || ((SharedSimpleAttrValue)attrValue).getData() == null) {
            return false;
        }
        return ((SharedSimpleAttrValue)attrValue).getCanonical().equals(this._szCanonicalData);
    }

    String getLexical() {
        return this._szLexicalData;
    }

    String getCanonical() {
        return this._szCanonicalData;
    }

    Object getData() {
        return this._data;
    }

    void setData(Object data) throws IdASException {
        if (this._sharedAttr.getAttrDataType() == null) {
            String szErrMsg = "sharedSimpleAttrValue:setData(data): Type for value on attribute '" + this._sharedAttr.getAttrID() + "' on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "' not defined";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        if (data == null) {
            String szErrMsg = "sharedSimpleAttrvalue:setData(data): Attempt to set a null value for attribute " + this._sharedAttr.getAttrID() + " on " + this._sharedAttrContainer.getContainerType() + " '" + this._sharedAttrContainer.getContainerID() + "'";
            this._log.debug((Object)szErrMsg);
            throw new IdASException(szErrMsg);
        }
        this._setDataFields(data);
    }
}

