/*******************************************************************************

 * Copyright (c) 2009 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.proxy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IAttributeUDI;
import org.eclipse.higgins.idas.udi.IAttributeUDIMetadata;
import org.eclipse.higgins.idas.udi.UDIResolver;
import org.eclipse.higgins.xdi4j.Predicate;
import org.eclipse.higgins.xdi4j.Subject;
import org.eclipse.higgins.xdi4j.exceptions.MessagingException;
import org.eclipse.higgins.xdi4j.idas.IdASUtil;
import org.eclipse.higgins.xdi4j.messaging.Message;
import org.eclipse.higgins.xdi4j.messaging.MessageResult;
import org.eclipse.higgins.xdi4j.messaging.Operation;
import org.eclipse.higgins.xdi4j.messaging.server.EndpointRegistry;
import org.eclipse.higgins.xdi4j.xri3.impl.XRI3Segment;

public class AttributeUDIResourceHandler extends EntityUDIResourceHandler {

	private static final Log log = LogFactory.getLog(EntityUDIResourceHandler.class);

	public static final XRI3Segment XRI_ATTRIBUTEID = new XRI3Segment("+");

	protected IAttributeUDIMetadata attributeUDIMetadata;

	public AttributeUDIResourceHandler(Message message, Subject subject, EndpointRegistry endpointRegistry, CleanupThread cleanupThread, String baseUri, UDIResolver udiResolver) {

		super(message, subject, endpointRegistry, cleanupThread, baseUri, udiResolver);
	}

	@Override
	public boolean executeGet(Operation operation, MessageResult messageResult, Object executionContext) throws MessagingException {

		super.executeGet(operation, messageResult, executionContext);

		// populate the message result

		try {

			Subject subject = messageResult.getGraph().getSubject(this.operationSubject.getSubjectXri());

			if (this.operationSubject.containsPredicate(XRI_ATTRIBUTEID) && this.attributeUDIMetadata.getAttributeID() != null) {

				Predicate predicate = subject.createPredicate(XRI_ATTRIBUTEID);
				predicate.createReference(IdASUtil.attrIDToXri(this.attributeUDIMetadata.getAttributeID()));
			}
		} catch (IdASException ex) {

			throw new MessagingException(ex.getMessage(), ex);
		}

		log.info("Successfully answered resultion request for Attribute UDI.");

		return(true);
	}

	@Override
	protected void resolveUDI(String udiStr) throws MessagingException {

		// resolve the Entity UDI

		try {

			IAttributeUDI attributeUDI = this.udiResolver.parseAttributeUDI(udiStr);
			if (attributeUDI == null) throw new MessagingException("Cannot parse the Attribute UDI: " + udiStr);

			this.attributeUDIMetadata = attributeUDI.getAttributeUDIMetadata();
			if (this.attributeUDIMetadata == null) throw new MessagingException("Cannot retrieve the Entity Metadata: " + udiStr);

			this.entityUDIMetadata = this.attributeUDIMetadata.getEntityUDIMetadata();
			if (this.entityUDIMetadata == null) throw new MessagingException("Cannot retrieve the Entity Metadata: " + udiStr);

			this.contextUDIMetadata = this.entityUDIMetadata.getContextUDIMetadata();
			if (this.contextUDIMetadata == null) throw new MessagingException("Cannot retrieve the Context Metadata: " + udiStr);
		} catch (MessagingException ex) {

			throw ex;
		} catch (Exception ex) {

			throw new MessagingException("Cannot resolve the Attribute UDI " + udiStr + ": " + ex.getMessage(), ex);
		}
	}
}
