/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import org.openxri.resolve.TrustType;

public class ResolverFlags {
    private boolean https;
    private boolean saml;
    private boolean refs;
    private boolean noDefaultT;
    private boolean noDefaultP;
    private boolean noDefaultM;
    private boolean uric;
    private boolean cid;

    public ResolverFlags() {
        this.https = false;
        this.saml = false;
        this.refs = true;
        this.noDefaultT = false;
        this.noDefaultP = false;
        this.noDefaultM = false;
        this.uric = false;
        this.cid = true;
    }

    public ResolverFlags(ResolverFlags other) {
        this.https = other.https;
        this.saml = other.saml;
        this.refs = other.refs;
        this.noDefaultT = other.noDefaultT;
        this.noDefaultP = other.noDefaultP;
        this.noDefaultM = other.noDefaultM;
        this.uric = other.uric;
        this.cid = other.cid;
    }

    public ResolverFlags(TrustType trustType, boolean followRefs) {
        this();
        this.setHttps(trustType.isHTTPS());
        this.setSaml(trustType.isSAML());
        this.setRefs(followRefs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ResolverFlags (");
        sb.append(this.toURIQuery());
        sb.append(")");
        return sb.toString();
    }

    public String toURIQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append("https=");
        sb.append(this.https);
        sb.append("&saml=");
        sb.append(this.saml);
        sb.append("&refs=");
        sb.append(this.refs);
        sb.append("&no_default_t=");
        sb.append(this.noDefaultT);
        sb.append("&no_default_p=");
        sb.append(this.noDefaultP);
        sb.append("&no_default_m=");
        sb.append(this.noDefaultM);
        sb.append("&uric=");
        sb.append(this.uric);
        sb.append("&cid=");
        sb.append(this.cid);
        return sb.toString();
    }

    public boolean isHttps() {
        return this.https;
    }

    public void setHttps(boolean https) {
        this.https = https;
    }

    public boolean isSaml() {
        return this.saml;
    }

    public void setSaml(boolean saml) {
        this.saml = saml;
    }

    public boolean isRefs() {
        return this.refs;
    }

    public void setRefs(boolean refs) {
        this.refs = refs;
    }

    public boolean isNoDefaultT() {
        return this.noDefaultT;
    }

    public void setNoDefaultT(boolean noDefaultT) {
        this.noDefaultT = noDefaultT;
    }

    public boolean isNoDefaultP() {
        return this.noDefaultP;
    }

    public void setNoDefaultP(boolean noDefaultP) {
        this.noDefaultP = noDefaultP;
    }

    public boolean isNoDefaultM() {
        return this.noDefaultM;
    }

    public void setNoDefaultM(boolean noDefaultM) {
        this.noDefaultM = noDefaultM;
    }

    public boolean isUric() {
        return this.uric;
    }

    public void setUric(boolean uric) {
        this.uric = uric;
    }

    public boolean isCid() {
        return this.cid;
    }

    public void setCid(boolean cid) {
        this.cid = cid;
    }

    public String getTrustParameters() {
        StringBuffer sb = new StringBuffer();
        sb.append("https");
        sb.append("=");
        sb.append(this.isHttps() ? "true" : "false");
        sb.append(";");
        sb.append("saml");
        sb.append("=");
        sb.append(this.isSaml() ? "true" : "false");
        return sb.toString();
    }
}

