/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.io.Serializable;
import org.openxri.resolve.exception.IllegalTrustTypeException;

public class TrustType
implements Serializable {
    public static final String TRUST_NONE = "none";
    public static final String TRUST_SAML = "saml";
    public static final String TRUST_HTTPS = "https";
    public static final String TRUST_SAML_HTTPS = "saml+https";
    public static final String TRUST = "trust";
    protected String type = "none";

    public TrustType() {
    }

    public TrustType(String type) throws IllegalTrustTypeException {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getParameterPair() {
        String https = this.type.equals(TRUST_HTTPS) || this.type.equals(TRUST_SAML_HTTPS) ? "true" : "false";
        String saml = this.type.equals(TRUST_SAML) || this.type.equals(TRUST_SAML_HTTPS) ? "true" : "false";
        return "https=" + https + ";" + TRUST_SAML + "=" + saml;
    }

    public void setParameterPair(boolean isHttps, boolean isSaml) {
        this.type = isHttps ? (isSaml ? TRUST_SAML_HTTPS : TRUST_HTTPS) : (isSaml ? TRUST_SAML : TRUST_NONE);
    }

    public void setType(String type) throws IllegalTrustTypeException {
        if (!((type = type.toLowerCase()).equals(TRUST_NONE) || type.equals(TRUST_SAML) || type.equals(TRUST_HTTPS) || type.equals(TRUST_SAML_HTTPS))) {
            throw new IllegalTrustTypeException(type);
        }
        this.type = type;
    }

    public boolean isHTTPS() {
        return this.type.equals(TRUST_HTTPS) || this.type.equals(TRUST_SAML_HTTPS);
    }

    public boolean isSAML() {
        return this.type.equals(TRUST_SAML) || this.type.equals(TRUST_SAML_HTTPS);
    }

    public boolean equals(String trustType) {
        return this.type.equalsIgnoreCase(trustType);
    }

    public String toString() {
        return this.getType();
    }
}

