/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.resolve.TrustType;
import org.openxri.xml.ForwardingService;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class AuthorityResolutionService
extends Service {
    public static final String SERVICE_TYPE = "xri://$res*auth*($v*2.0)";
    public static final String SERVICE_MEDIA_TYPE = "application/xrds+xml";
    public static final String TRUST_TYPE_SEPARATOR = ";";
    public static final Integer URI_PRIORITY_HTTPS = new Integer(1);
    public static final Integer URI_PRIORITY_DEFAULT = new Integer(2);

    public AuthorityResolutionService(URI[] resolvers, String providerID, TrustType trustType, String append) {
        if (append == null) {
            append = "none";
        }
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addType(new SEPType(SERVICE_TYPE, null, Boolean.TRUE));
        String mediaType = SERVICE_MEDIA_TYPE;
        if (trustType != null && !trustType.equals("none")) {
            mediaType = mediaType + TRUST_TYPE_SEPARATOR + trustType.getParameterPair();
        }
        this.addMediaType(new SEPMediaType(mediaType, null, Boolean.FALSE));
        for (int i = 0; i < resolvers.length; ++i) {
            URI resolver = resolvers[i];
            try {
                Integer priority = resolver.getScheme().toLowerCase().equals("https") ? URI_PRIORITY_HTTPS : URI_PRIORITY_DEFAULT;
                this.addURI(new SEPUri(resolver.toString(), priority, append));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public AuthorityResolutionService(URI resolver, String providerId, TrustType trustType, String append) {
        this(new URI[]{resolver}, providerId, trustType, append);
    }

    public AuthorityResolutionService(URI[] resolvers, String providerId, TrustType trustType) {
        this(resolvers, providerId, trustType, null);
    }

    public AuthorityResolutionService(URI resolver, String providerId, TrustType trustType) {
        this(new URI[]{resolver}, providerId, trustType, null);
    }

    public AuthorityResolutionService(URI[] resolvers, String providerId) {
        this(resolvers, providerId, null, null);
    }

    public AuthorityResolutionService(URI resolver, String providerId) {
        this(new URI[]{resolver}, providerId, null, null);
    }

    public AuthorityResolutionService(URI[] resolvers) {
        this(resolvers, null, null, null);
    }

    public AuthorityResolutionService(URI resolver) {
        this(new URI[]{resolver}, null, null, null);
    }

    public static boolean isInstance(Service service) {
        if (service instanceof ForwardingService) {
            return true;
        }
        List serviceTypes = service.getTypes();
        for (int i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (!SERVICE_TYPE.equals(serviceType.getValue())) continue;
            return true;
        }
        return false;
    }
}

