/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.xml.ForwardingService;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class ContactService
extends Service {
    public static final String SERVICE_TYPE = "xri://+i-service*(+contact)*($v*1.0)";
    public static final String CONTACT_PATH = "(+contact)";

    public ContactService(URI[] contactPages, String providerID, boolean makeDefault) {
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addPath(new SEPPath(CONTACT_PATH, null, Boolean.TRUE));
        if (makeDefault) {
            this.addPath(new SEPPath(null, "null", null));
        }
        this.addType(new SEPType(SERVICE_TYPE, null, Boolean.TRUE));
        this.addType(new SEPType(null, "null", null));
        this.addMediaType(new SEPMediaType(null, "default", null));
        for (int i = 0; i < contactPages.length; ++i) {
            URI contactPage = contactPages[i];
            try {
                this.addURI(new SEPUri(contactPage.toString(), null, "qxri"));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public ContactService(URI contactPage, String providerID, boolean makeDefault) {
        this(new URI[]{contactPage}, providerID, makeDefault);
    }

    public ContactService(URI[] contactPages, String providerID) {
        this(contactPages, providerID, true);
    }

    public ContactService(URI contactPage, String providerID) {
        this(new URI[]{contactPage}, providerID, true);
    }

    public ContactService(URI[] contactPages) {
        this(contactPages, null, true);
    }

    public ContactService(URI contactPage) {
        this(new URI[]{contactPage}, null, true);
    }

    public static boolean isInstance(Service service) {
        if (service instanceof ForwardingService) {
            return true;
        }
        List serviceTypes = service.getTypes();
        for (int i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (!SERVICE_TYPE.equals(serviceType.getValue())) continue;
            return true;
        }
        return false;
    }
}

