/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class DefaultService
extends Service {
    public DefaultService(URI[] pages, String providerID) {
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addMediaType(new SEPMediaType(null, "default", Boolean.FALSE));
        this.addType(new SEPType(null, "default", Boolean.FALSE));
        this.addPath(new SEPPath(null, "default", Boolean.FALSE));
        for (int i = 0; i < pages.length; ++i) {
            URI page = pages[i];
            try {
                this.addURI(new SEPUri(page.toString(), null, "none"));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public DefaultService(URI page, String providerID) {
        this(new URI[]{page}, providerID);
    }

    public DefaultService(URI[] pages) {
        this(pages, null);
    }

    public DefaultService(URI page) {
        this(new URI[]{page}, null);
    }

    public static boolean isInstance(Service service) {
        int i;
        if (service instanceof DefaultService) {
            return true;
        }
        boolean mediaTypeNull = false;
        boolean serviceTypeNull = false;
        boolean pathNull = false;
        List mediaTypes = service.getMediaTypes();
        List serviceTypes = service.getTypes();
        List paths = service.getPaths();
        for (i = 0; i < mediaTypes.size(); ++i) {
            SEPMediaType mediaType = (SEPMediaType)mediaTypes.get(i);
            if (!mediaType.getMatch().equals("null")) continue;
            mediaTypeNull = true;
        }
        for (i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (!serviceType.getMatch().equals("null")) continue;
            serviceTypeNull = true;
        }
        for (i = 0; i < paths.size(); ++i) {
            SEPPath path = (SEPPath)paths.get(i);
            if (!path.getMatch().equals("null")) continue;
            pathNull = true;
        }
        return mediaTypeNull && serviceTypeNull && pathNull;
    }
}

