/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.openxri.util.DOMUtils;
import org.openxri.xml.XRD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XRDS
implements Serializable {
    private Vector moXRDs = new Vector();
    private String ref = null;
    private String redirect = null;

    public XRDS() {
    }

    public XRDS(Element oElem, boolean bKeepXRIDDOMs) throws URISyntaxException, ParseException {
        this.fromDOM(oElem, bKeepXRIDDOMs);
    }

    public void add(XRD oDescriptor) {
        this.moXRDs.add(oDescriptor);
    }

    public void add(XRDS oDescriptor) {
        this.moXRDs.add(oDescriptor);
    }

    public void addAll(XRDS other) {
        for (int i = 0; i < other.getNumChildren(); ++i) {
            if (other.isXRDSAt(i)) {
                this.add(other.getXRDSAt(i));
                continue;
            }
            this.add(other.getDescriptorAt(i));
        }
    }

    public int getNumChildren() {
        return this.moXRDs == null ? 0 : this.moXRDs.size();
    }

    public int getNumXRD() {
        int count = 0;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            if (this.isXRDSAt(i)) continue;
            ++count;
        }
        return count;
    }

    public int getNumXRDS() {
        return this.getNumChildren() - this.getNumXRD();
    }

    public XRD getDescriptorAt(int n) {
        if (n >= this.getNumChildren()) {
            return null;
        }
        Object o = this.moXRDs.get(n);
        if (o instanceof XRD) {
            return (XRD)o;
        }
        return null;
    }

    public XRDS getXRDSAt(int n) {
        if (n >= this.getNumChildren()) {
            return null;
        }
        Object o = this.moXRDs.get(n);
        if (o instanceof XRDS) {
            return (XRDS)o;
        }
        return null;
    }

    public boolean isXRDSAt(int n) {
        Object o = this.moXRDs.get(n);
        if (o == null) {
            return false;
        }
        return o instanceof XRDS;
    }

    public boolean isXRDAt(int n) {
        Object o = this.moXRDs.get(n);
        if (o == null) {
            return false;
        }
        return o instanceof XRD;
    }

    public void reset() {
        this.moXRDs = new Vector();
    }

    public void fromDOM(Element oElem, boolean bKeepXRIDDOMs) throws ParseException, URISyntaxException {
        this.reset();
        if (oElem != null) {
            NamedNodeMap attribs = oElem.getAttributes();
            Node attribNode = attribs.getNamedItem("ref");
            if (attribNode != null) {
                this.ref = attribNode.getNodeValue();
            }
            if ((attribNode = attribs.getNamedItem("redirect")) != null) {
                this.redirect = attribNode.getNodeValue();
            }
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            if (oChild.getLocalName().equals("XRD")) {
                this.moXRDs.add(new XRD(oChild, bKeepXRIDDOMs));
            } else if (oChild.getLocalName().equals("XRDS")) {
                this.moXRDs.add(new XRDS(oChild, bKeepXRIDDOMs));
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public Element toDOM(Document oDoc) {
        if (oDoc == null) {
            return null;
        }
        Element oElem = oDoc.createElementNS("xri://$xrds", "XRDS");
        if (this.ref != null) {
            oElem.setAttribute("ref", this.ref);
        }
        if (this.redirect != null) {
            oElem.setAttribute("redirect", this.redirect);
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            Element oLocal = null;
            if (this.isXRDSAt(i)) {
                oLocal = this.getXRDSAt(i).toDOM(oDoc);
            } else if (this.isXRDAt(i)) {
                oLocal = this.getDescriptorAt(i).toDOM(oDoc);
            }
            if (oLocal == null) continue;
            oElem.appendChild(oLocal);
        }
        return oElem;
    }

    public void clearDOM() {
        for (int i = 0; i < this.getNumChildren(); ++i) {
            this.getDescriptorAt(i).clearDOM();
        }
    }

    public String serializeDescriptorDOM() {
        return this.toString();
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public XRD getFinalXRD() {
        int last = this.getNumChildren() - 1;
        if (last < 0) {
            return null;
        }
        if (this.isXRDSAt(last)) {
            return this.getXRDSAt(last).getFinalXRD();
        }
        return this.getDescriptorAt(last);
    }

    public XRDS getFinalXRDS() {
        int last = this.getNumChildren() - 1;
        if (last < 0) {
            return null;
        }
        if (this.isXRDSAt(last)) {
            return this.getXRDSAt(last).getFinalXRDS();
        }
        return this;
    }

    public void replaceFinalXRD(XRDS children) {
        XRDS finalXRDS = this.getFinalXRDS();
        finalXRDS.removeChildAt(finalXRDS.getNumChildren() - 1);
        finalXRDS.addAll(children);
    }

    protected void removeChildAt(int i) {
        if (i < this.moXRDs.size()) {
            this.moXRDs.remove(i);
        }
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = redirect;
    }
}

