/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import java.io.UnsupportedEncodingException;
import org.openxri.AuthorityPath;
import org.openxri.IRIUtils;
import org.openxri.Parsable;
import org.openxri.ParseStream;
import org.openxri.XRIAbsolutePath;
import org.openxri.XRIFragment;
import org.openxri.XRINoSchemePath;
import org.openxri.XRIParseException;
import org.openxri.XRIPath;
import org.openxri.XRIQuery;
import org.openxri.XRIReference;

public class XRI
extends Parsable
implements XRIReference {
    public static final String PDELIM_S = "!";
    public static final String RDELIM_S = "*";
    public static final char PDELIM = '!';
    public static final char RDELIM = '*';
    public static final String XRI_SCHEME = "xri://";
    public static final int XRI_SCHEME_LENGTH = "xri://".length();
    AuthorityPath moAuthorityPath = null;
    XRIAbsolutePath moAbsolutePath = null;
    XRIQuery query = null;
    XRIFragment fragment = null;

    XRI() {
    }

    public XRI(XRI oXRI) {
        this.moAuthorityPath = oXRI.getAuthorityPath();
        this.moAbsolutePath = oXRI.getXRIAbsolutePath();
        this.query = oXRI.getQuery();
        this.fragment = oXRI.getFragment();
        this.setParsedXRI();
    }

    public XRIAbsolutePath getXRIAbsolutePath() {
        return this.moAbsolutePath;
    }

    public XRI(String sXRI) {
        super(sXRI);
        this.parse();
    }

    public XRI(AuthorityPath oAuthority) {
        this.moAuthorityPath = oAuthority;
        this.setParsedXRI();
    }

    public XRI(AuthorityPath oAuthority, XRIPath oPath) {
        if (oAuthority == null) {
            throw new XRIParseException();
        }
        this.moAuthorityPath = oAuthority;
        if (oPath != null) {
            if (oPath instanceof XRINoSchemePath) {
                this.moAbsolutePath = new XRIAbsolutePath((XRINoSchemePath)oPath);
            } else if (oPath instanceof XRIAbsolutePath) {
                this.moAbsolutePath = (XRIAbsolutePath)oPath;
            }
        }
        this.setParsedXRI();
    }

    public XRI(AuthorityPath oAuthority, XRIPath oPath, XRIQuery query, XRIFragment fragment) {
        if (oAuthority == null) {
            throw new XRIParseException();
        }
        this.moAuthorityPath = oAuthority;
        if (oPath != null) {
            if (oPath instanceof XRINoSchemePath) {
                this.moAbsolutePath = new XRIAbsolutePath((XRINoSchemePath)oPath);
            } else if (oPath instanceof XRIAbsolutePath) {
                this.moAbsolutePath = (XRIAbsolutePath)oPath;
            }
        }
        this.query = query;
        this.fragment = fragment;
        this.setParsedXRI();
    }

    public static XRI fromIRINormalForm(String iri) {
        String xriNF = IRIUtils.IRItoXRI(iri);
        return new XRI(xriNF);
    }

    public static XRI fromURINormalForm(String uri) {
        String iriNF;
        try {
            iriNF = IRIUtils.URItoIRI(uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new XRIParseException("UTF-8 encoding not supported: " + e.getMessage());
        }
        String xriNF = IRIUtils.IRItoXRI(iriNF);
        return new XRI(xriNF);
    }

    void setParsedXRI() {
        String sValue = XRI_SCHEME + this.moAuthorityPath.toString();
        if (this.moAbsolutePath != null) {
            sValue = sValue + this.moAbsolutePath.toString();
        }
        if (this.query != null) {
            sValue = sValue + this.query.toString();
        }
        if (this.fragment != null) {
            sValue = sValue + this.query.toString();
        }
        this.setParsedValue(sValue);
    }

    public boolean isAbsolute() {
        this.parse();
        return this.moAuthorityPath != null;
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    static AuthorityPath scanSchemeAuthority(ParseStream oParseStream) {
        AuthorityPath oAuthorityPath;
        String sScheme;
        if (oParseStream.empty()) {
            return null;
        }
        ParseStream oAuthStream = oParseStream.begin();
        if (oParseStream.getData().length() >= XRI_SCHEME_LENGTH && (sScheme = oAuthStream.getData().substring(0, XRI_SCHEME_LENGTH)) != null && sScheme.equalsIgnoreCase(XRI_SCHEME)) {
            oAuthStream.consume(XRI_SCHEME_LENGTH);
        }
        if ((oAuthorityPath = AuthorityPath.scanAuthority(oAuthStream)) != null) {
            oParseStream.end(oAuthStream);
        }
        return oAuthorityPath;
    }

    public String toString(boolean wantScheme, boolean caseFoldAuthority) {
        StringBuffer sb = new StringBuffer();
        if (this.moAuthorityPath != null) {
            if (wantScheme) {
                sb.append(XRI_SCHEME);
            }
            String a = this.moAuthorityPath.toString();
            if (caseFoldAuthority) {
                a = a.toLowerCase();
            }
            sb.append(a);
        }
        if (this.moAbsolutePath != null) {
            sb.append(this.moAbsolutePath.toString());
        }
        if (this.query != null) {
            sb.append("?");
            sb.append(this.query.toString());
        }
        if (this.fragment != null) {
            sb.append("#");
            sb.append(this.fragment.toString());
        }
        return sb.toString();
    }

    public boolean equals(XRI x) {
        return this.toString(false, true).equals(x.toString(false, true));
    }

    public String toIRINormalForm() {
        String iri = "";
        if (this.moAuthorityPath != null) {
            iri = XRI_SCHEME + this.moAuthorityPath.toIRINormalForm();
        }
        if (this.moAbsolutePath != null) {
            iri = iri + this.moAbsolutePath.toIRINormalForm();
        }
        if (this.query != null) {
            iri = iri + "?" + this.query.toIRINormalForm();
        }
        if (this.fragment != null) {
            iri = iri + "#" + this.fragment.toIRINormalForm();
        }
        return iri;
    }

    public String toURINormalForm() {
        String iri = this.toIRINormalForm();
        return IRIUtils.IRItoURI(iri);
    }

    boolean doScan(ParseStream oStream) {
        XRIFragment fragment;
        XRIQuery query;
        this.moAuthorityPath = XRI.scanSchemeAuthority(oStream);
        if (this.moAuthorityPath == null) {
            return false;
        }
        XRIAbsolutePath oPath = new XRIAbsolutePath();
        if (oPath.scan(oStream)) {
            this.moAbsolutePath = oPath;
        }
        if ((query = new XRIQuery()).scan(oStream)) {
            this.query = query;
        }
        if ((fragment = new XRIFragment()).scan(oStream)) {
            this.fragment = fragment;
        }
        return true;
    }

    public AuthorityPath getAuthorityPath() {
        return this.moAuthorityPath;
    }

    public XRIPath getXRIPath() {
        return this.moAbsolutePath;
    }

    public XRIQuery getQuery() {
        return this.query;
    }

    public XRIFragment getFragment() {
        return this.fragment;
    }
}

