/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import org.openxri.Characters;
import org.openxri.IRIUtils;
import org.openxri.Parsable;
import org.openxri.ParseStream;

public class XRIQuery
extends Parsable {
    protected String query = null;

    XRIQuery() {
    }

    public XRIQuery(String sQuery) {
        super(sQuery);
        this.parse();
    }

    void setParsedValue(String sValue) {
        this.msValue = sValue != null ? (sValue.length() > 0 && sValue.charAt(0) == '?' ? sValue.substring(1) : sValue) : "";
        this.mbParsed = true;
        this.mbParseResult = true;
    }

    boolean doScan(ParseStream oStream) {
        if (oStream.empty() || oStream.getData().charAt(0) != '?') {
            return false;
        }
        oStream.consume(1);
        int n = this.scanIQueryChars(oStream.getData());
        oStream.consume(n);
        return true;
    }

    private int scanIQueryChars(String s) {
        int c;
        for (int i = 0; i < s.length(); i += UTF16.getCharCount((int)c)) {
            c = UTF16.charAt((String)s, (int)i);
            if (Characters.isIPChar(c)) continue;
            if (Characters.isEscaped(c, s, i)) {
                i += 2;
                continue;
            }
            if (UCharacter.getType((int)c) == 17 || c == 47 || c == 63) continue;
            return i;
        }
        return s.length();
    }

    public String toIRINormalForm() {
        return IRIUtils.XRItoIRI(this.toString(), false);
    }
}

