/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import java.util.ArrayList;
import java.util.List;
import org.openxri.xri3.XRILiteral;
import org.openxri.xri3.XRISegment;
import org.openxri.xri3.XRISubSegment;
import org.openxri.xri3.impl.XRI3Literal;
import org.openxri.xri3.impl.XRI3SubSegment;
import org.openxri.xri3.impl.XRI3SyntaxComponent;
import org.openxri.xri3.impl.XRI3Util;
import org.openxri.xri3.impl.parser.Parser;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;

public class XRI3Segment
extends XRI3SyntaxComponent
implements XRISegment {
    private static final long serialVersionUID = 8461242564541252885L;
    private Rule rule;
    private XRI3Literal literal;
    private List subSegments;

    public XRI3Segment(String string) throws ParserException {
        this.rule = XRI3Util.getParser().parse("xri-segment", string);
        this.read();
    }

    XRI3Segment(Rule rule) {
        this.rule = rule;
        this.read();
    }

    private void reset() {
        this.subSegments = new ArrayList();
    }

    private void read() {
        this.reset();
        Rule object = this.rule;
        if (object instanceof Parser.xri_segment) {
            ArrayList list_xri_segment = ((Parser.xri_segment)object).rules;
            if (list_xri_segment.size() < 1) {
                return;
            }
            object = list_xri_segment.get(0);
            if (object instanceof Parser.literal) {
                this.literal = new XRI3Literal((Parser.literal)object);
            } else if (object instanceof Parser.subseg) {
                this.subSegments.add(new XRI3SubSegment((Parser.subseg)object));
            } else {
                throw new ClassCastException(object.getClass().getName());
            }
            if (list_xri_segment.size() < 2) {
                return;
            }
            for (int i = 1; i < list_xri_segment.size(); ++i) {
                object = list_xri_segment.get(i);
                this.subSegments.add(new XRI3SubSegment((Parser.subseg)object));
            }
        } else if (object instanceof Parser.xri_segment_nz) {
            ArrayList list_xri_segment_nz = ((Parser.xri_segment_nz)object).rules;
            if (list_xri_segment_nz.size() < 1) {
                return;
            }
            object = list_xri_segment_nz.get(0);
            if (object instanceof Parser.literal) {
                this.literal = new XRI3Literal((Parser.literal)object);
            } else if (object instanceof Parser.subseg) {
                this.subSegments.add(new XRI3SubSegment((Parser.subseg)object));
            } else {
                throw new ClassCastException(object.getClass().getName());
            }
            if (list_xri_segment_nz.size() < 2) {
                return;
            }
            for (int i = 1; i < list_xri_segment_nz.size(); ++i) {
                object = list_xri_segment_nz.get(i);
                this.subSegments.add(new XRI3SubSegment((Parser.subseg)object));
            }
        } else if (object instanceof Parser.xri_segment_nc) {
            ArrayList list_xri_segment_nc = ((Parser.xri_segment_nc)object).rules;
            if (list_xri_segment_nc.size() < 1) {
                return;
            }
            object = list_xri_segment_nc.get(0);
            if (object instanceof Parser.literal_nc) {
                this.literal = new XRI3Literal((Parser.literal_nc)object);
            } else if (object instanceof Parser.subseg) {
                this.subSegments.add(new XRI3SubSegment((Parser.subseg)object));
            } else {
                throw new ClassCastException(object.getClass().getName());
            }
            if (list_xri_segment_nc.size() < 2) {
                return;
            }
            for (int i = 1; i < list_xri_segment_nc.size(); ++i) {
                object = list_xri_segment_nc.get(i);
                this.subSegments.add(new XRI3SubSegment((Parser.subseg)object));
            }
        } else {
            throw new ClassCastException(object.getClass().getName());
        }
    }

    public Rule getParserObject() {
        return this.rule;
    }

    public boolean hasLiteral() {
        return this.literal != null;
    }

    public XRILiteral getLiteral() {
        return this.literal;
    }

    public List getSubSegments() {
        return this.subSegments;
    }

    public int getNumSubSegments() {
        return this.subSegments.size();
    }

    public XRISubSegment getSubSegment(int i) {
        return (XRISubSegment)this.subSegments.get(i);
    }

    public XRISubSegment getFirstSubSegment() {
        if (this.subSegments.size() < 1) {
            return null;
        }
        return (XRISubSegment)this.subSegments.get(0);
    }

    public XRISubSegment getLastSubSegment() {
        if (this.subSegments.size() < 1) {
            return null;
        }
        return (XRISubSegment)this.subSegments.get(this.subSegments.size() - 1);
    }

    public boolean startsWith(XRISubSegment[] subSegments) {
        if (this.subSegments.size() < subSegments.length) {
            return false;
        }
        for (int i = 0; i < subSegments.length; ++i) {
            if (this.subSegments.get(i).equals(subSegments[i])) continue;
            return false;
        }
        return true;
    }
}

