/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xri3.impl;

import java.util.ArrayList;
import org.openxri.xri3.XRILiteral;
import org.openxri.xri3.XRISubSegment;
import org.openxri.xri3.XRIXRef;
import org.openxri.xri3.impl.XRI3Constants;
import org.openxri.xri3.impl.XRI3Literal;
import org.openxri.xri3.impl.XRI3SyntaxComponent;
import org.openxri.xri3.impl.XRI3Util;
import org.openxri.xri3.impl.XRI3XRef;
import org.openxri.xri3.impl.parser.Parser;
import org.openxri.xri3.impl.parser.ParserException;
import org.openxri.xri3.impl.parser.Rule;

public class XRI3SubSegment
extends XRI3SyntaxComponent
implements XRISubSegment {
    private static final long serialVersionUID = 821195692608034080L;
    private Rule rule;
    private Character gcs;
    private Character lcs;
    private XRI3Literal literal;
    private XRI3XRef xref;

    public XRI3SubSegment(String string) throws ParserException {
        this.rule = XRI3Util.getParser().parse("subseg", string);
        this.read();
    }

    public XRI3SubSegment(Character gcs, XRISubSegment localSubSegment) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(gcs);
        buffer.append(localSubSegment.toString());
        this.rule = XRI3Util.getParser().parse("subseg", buffer.toString());
        this.read();
    }

    public XRI3SubSegment(Character cs, String uri) throws ParserException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(cs.toString());
        buffer.append("(");
        buffer.append(uri);
        buffer.append(")");
        this.rule = XRI3Util.getParser().parse("subseg", buffer.toString());
        this.read();
    }

    XRI3SubSegment(Rule rule) {
        this.rule = rule;
        this.read();
    }

    private void reset() {
        this.gcs = null;
        this.lcs = null;
        this.literal = null;
        this.xref = null;
    }

    private void read() {
        this.reset();
        Rule object = this.rule;
        if (object instanceof Parser.subseg) {
            ArrayList list_subseg = ((Parser.subseg)object).rules;
            if (list_subseg.size() < 1) {
                return;
            }
            object = list_subseg.get(0);
        }
        if (object instanceof Parser.global_subseg) {
            ArrayList list_global_subseg = ((Parser.global_subseg)object).rules;
            if (list_global_subseg.size() < 1) {
                return;
            }
            object = list_global_subseg.get(0);
            this.gcs = new Character(((Parser.gcs_char)object).spelling.charAt(0));
            if (list_global_subseg.size() < 2) {
                return;
            }
            object = list_global_subseg.get(1);
        }
        if (object instanceof Parser.local_subseg) {
            ArrayList list_local_subseg = ((Parser.local_subseg)object).rules;
            if (list_local_subseg.size() < 1) {
                return;
            }
            object = list_local_subseg.get(0);
            this.lcs = new Character(((Parser.lcs_char)object).spelling.charAt(0));
            if (list_local_subseg.size() < 2) {
                return;
            }
            object = list_local_subseg.get(1);
        }
        if (object instanceof Parser.literal) {
            this.literal = new XRI3Literal((Parser.literal)object);
        } else if (object instanceof Parser.xref) {
            this.xref = new XRI3XRef((Parser.xref)object);
        } else {
            return;
        }
    }

    public Rule getParserObject() {
        return this.rule;
    }

    public boolean hasGCS() {
        return this.gcs != null;
    }

    public boolean hasLCS() {
        return this.lcs != null;
    }

    public boolean hasLiteral() {
        return this.literal != null;
    }

    public boolean hasXRef() {
        return this.xref != null;
    }

    public Character getGCS() {
        return this.gcs;
    }

    public Character getLCS() {
        return this.lcs;
    }

    public XRILiteral getLiteral() {
        return this.literal;
    }

    public XRIXRef getXRef() {
        return this.xref;
    }

    public boolean isGlobal() {
        return this.hasGCS();
    }

    public boolean isLocal() {
        return this.hasLCS() && !this.hasGCS();
    }

    public boolean isPersistent() {
        return this.hasLCS() && this.getLCS().equals(XRI3Constants.LCS_BANG);
    }

    public boolean isReassignable() {
        return this.hasGCS() && !this.hasLCS() || this.hasLCS() && this.getLCS().equals(XRI3Constants.LCS_STAR);
    }
}

