/*******************************************************************************
 * Copyright (c) 2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.idas.registry.contextid;

import java.net.URI;
import java.util.Map;

import org.eclipse.higgins.idas.api.IContextId;

public class GenericContextId implements IContextId {

	protected String[] types;
	protected URI[] uris;
	protected Map configuration;

	public GenericContextId(String[] types, URI[] uris, Map configuration) {

		this.types = types;
		this.uris = uris;
		this.configuration = configuration;
	}

	public String[] getTypes() {

		return(this.types);
	}

	public URI[] getUris() {

		return(this.uris);
	}

	public Map getConfiguration() {

		return(this.configuration);
	}
}
