/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.spi.AttributeNotification;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.idas.spi.IAttributeContainer;

public class BasicAttributeSet
implements IHasAttributes,
IAttributeContainer {
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$spi$BasicAttributeSet == null ? (class$org$eclipse$higgins$idas$spi$BasicAttributeSet = BasicAttributeSet.class$("org.eclipse.higgins.idas.spi.BasicAttributeSet")) : class$org$eclipse$higgins$idas$spi$BasicAttributeSet).getName());
    private Hashtable _attrs;
    private IAttributeContainer _attrContainer = this;
    private IContext _context;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$spi$BasicAttributeSet;

    public BasicAttributeSet() {
        this._attrs = new Hashtable();
    }

    public BasicAttributeSet(Iterator attrs, IAttributeContainer container, IContext context) throws IdASException {
        this();
        this._context = context;
        if (container != null) {
            this._attrContainer = container;
        }
        if (attrs != null) {
            while (attrs.hasNext()) {
                this.addAttribute((IAttribute)attrs.next());
            }
        }
    }

    public Iterator getAttributes() throws IdASException {
        return this._attrs.values().iterator();
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return (IAttribute)this._attrs.get(attrID);
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        throw new NotSingleValuedAttributeException("BasicAttributeSet has no knowledge of the attributes' models, thus all attributes are treated as multi-value capable.");
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        BasicAttribute attr = new BasicAttribute(attrID, (Iterator)null, (IAttributeContainer)this, this._context);
        AttributeNotification attrNotif = new AttributeNotification(attr, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD", null, null);
        this.updateNotification(attrNotif);
        return attr;
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        BasicAttribute attr = new BasicAttribute(copyFrom, this, this._context);
        AttributeNotification attrNotif = new AttributeNotification(attr, "urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD", null, null);
        this.updateNotification(attrNotif);
        return attr;
    }

    public void removeAttribute(URI attrID) throws IdASException {
        BasicAttribute attr = new BasicAttribute(attrID, (Iterator)null, (IAttributeContainer)this, this._context);
        attr.remove();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAttributeValue(IAttribute attr) throws IdASException {
        BasicAttribute basicAttr;
        IAttribute localAttr = this.getAttribute(attr.getAttrID());
        if (localAttr != null) {
            Iterator passedVals = attr.getValues();
            Vector<IAttributeValue> nonExistantVals = new Vector<IAttributeValue>();
            while (passedVals.hasNext()) {
                IAttributeValue passedVal = (IAttributeValue)passedVals.next();
                Iterator localVals = localAttr.getValues();
                boolean bFoundLocalVal = false;
                while (localVals.hasNext()) {
                    IAttributeValue localVal = (IAttributeValue)localVals.next();
                    if (!localVal.equals(passedVal)) continue;
                    localVal.remove();
                    bFoundLocalVal = true;
                    break;
                }
                if (bFoundLocalVal) continue;
                nonExistantVals.add(passedVal);
            }
            if (nonExistantVals.isEmpty()) return;
            basicAttr = new BasicAttribute(attr.getAttrID(), nonExistantVals.iterator(), null, this._context);
        } else {
            basicAttr = new BasicAttribute(attr, null, this._context);
        }
        basicAttr.setContainer(this);
        Iterator iter = basicAttr.getValues();
        while (iter.hasNext()) {
            IAttributeValue val = (IAttributeValue)iter.next();
            val.remove();
        }
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        BasicAttribute attr = new BasicAttribute(attrID, value, null, this._context);
        this.removeAttributeValue(attr);
    }

    public BasicAttribute addUnnotifiedAttribute(URI attrID) throws IdASException, InvalidTypeException {
        BasicAttribute attr = new BasicAttribute(attrID, (Iterator)null, null, this._context);
        this.insertAttribute(attr);
        return attr;
    }

    public BasicAttribute addUnnotifiedAttribute(IAttribute copyFrom) throws IdASException {
        BasicAttribute attr = new BasicAttribute(copyFrom, null, this._context);
        this.insertAttribute(attr);
        return attr;
    }

    private void insertAttribute(IAttribute attr) throws IdASException {
        this._log.debug((Object)("Inserting attribute - " + attr.getAttrID()));
        this._attrs.put(attr.getAttrID(), attr);
    }

    private void _removeAttribute(URI attrID) throws IdASException {
        this._log.debug((Object)("Removing attribute - " + attrID));
        this._attrs.remove(attrID);
    }

    public void updateNotification(AttributeNotification attrNotif) throws IdASException {
        this._log.debug((Object)("Received attribute update notification - " + attrNotif.getAction() + ", " + attrNotif.getAttr().getAttrID().toString()));
        if (attrNotif.getAction().equals("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_ADD")) {
            this.insertAttribute(attrNotif.getAttr());
        } else if (attrNotif.getAction().equals("urn:eclipse.higgins.idas.spi.AttributeNotification.UPDATE_REMOVE")) {
            this._removeAttribute(attrNotif.getAttr().getAttrID());
        }
        if (this._attrContainer != this) {
            this._log.debug((Object)("Notifying containing container - " + this._attrContainer));
            this._attrContainer.updateNotification(attrNotif);
        }
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        int localCount = 0;
        int attrCount = 0;
        Iterator iter = attributes.getAttributes();
        while (iter.hasNext()) {
            IAttribute attr = (IAttribute)iter.next();
            if (!this._contains(attr)) {
                return false;
            }
            ++attrCount;
        }
        iter = this.getAttributes();
        while (iter.hasNext()) {
            iter.next();
            ++localCount;
        }
        return localCount == attrCount;
    }

    private boolean _contains(IAttribute attr) throws IdASException {
        Iterator iter = this.getAttributes();
        while (iter.hasNext()) {
            if (!((IAttribute)iter.next()).equals(attr)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

