/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eclipse.higgins.idas.api.IComplexMetaValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.IMetadataValue;
import org.eclipse.higgins.idas.api.ISimpleMetaValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.model.IMetadataModel;
import org.eclipse.higgins.idas.spi.IMetadataContainer;
import org.eclipse.higgins.idas.spi.MetadataNotification;
import org.eclipse.higgins.idas.spi.MetadataValueNotification;

public class BasicMetadata
implements IMetadata {
    private Logger _log = Logger.getLogger((String)(class$org$eclipse$higgins$idas$spi$BasicMetadata == null ? (class$org$eclipse$higgins$idas$spi$BasicMetadata = BasicMetadata.class$("org.eclipse.higgins.idas.spi.BasicMetadata")) : class$org$eclipse$higgins$idas$spi$BasicMetadata).getName());
    private URI _metaID;
    private Vector _values;
    private IMetadataContainer _container;
    private IContext _context;
    static /* synthetic */ Class class$org$eclipse$higgins$idas$spi$BasicMetadata;

    public BasicMetadata(IMetadata copyFrom, IMetadataContainer container, IContext context) throws IdASException {
        this._context = context;
        this._init(copyFrom.getMetaID(), copyFrom.getValues(), container);
    }

    public BasicMetadata(URI metaID, IMetadataContainer container) throws IdASException {
        this._context = null;
        this._init(metaID, null, container);
    }

    public BasicMetadata(URI metaID, IMetadataValue value, IMetadataContainer container, IContext context) throws IdASException {
        this._context = context;
        if (value != null) {
            Vector<IMetadataValue> v = new Vector<IMetadataValue>(1);
            v.add(value);
            this._init(metaID, v.iterator(), container);
        } else {
            this._init(metaID, null, container);
        }
    }

    public BasicMetadata(URI metaID, Iterator values, IMetadataContainer container, IContext context) throws IdASException {
        this._context = context;
        this._init(metaID, values, container);
    }

    private void _init(URI metaID, Iterator values, IMetadataContainer container) throws IdASException {
        this._metaID = metaID;
        this._container = container;
        this._values = new Vector();
        if (values != null) {
            while (values.hasNext()) {
                this._addValue((IMetadataValue)values.next());
            }
        }
    }

    private void _addValue(IMetadataValue val) throws IdASException {
        this._values.add(val);
        this._log.debug((Object)("Sending value add notification - " + val.getModel().getType().toString()));
        MetadataValueNotification valueNotif = new MetadataValueNotification(val, "urn:eclipse.higgins.idas.spi.MetadataValueNotification.UPDATE_ADD", null);
        this.updateNotification(valueNotif);
    }

    private boolean _containsValue(IMetadataValue value) throws IdASException {
        Iterator iter = this.getValues();
        boolean bRet = false;
        while (iter.hasNext()) {
            IMetadataValue localVal = (IMetadataValue)iter.next();
            if (!localVal.equals(value)) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public URI getMetaID() throws IdASException {
        return this._metaID;
    }

    public Iterator getValues() throws IdASException {
        return ((Vector)this._values.clone()).iterator();
    }

    public IMetadataModel getModel() throws IdASException {
        if (this._context != null) {
            return (IMetadataModel)this._context.getContextModel().getModel(this.getMetaID());
        }
        throw new NotImplementedException("No associated context to obtain model");
    }

    public IComplexMetaValue addComplexValue(URI type) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public ISimpleMetaValue addSimpleValue(URI type, Object data) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IMetadataValue addValue(URI type) throws IdASException, InvalidTypeException {
        throw new NotImplementedException();
    }

    public IMetadataValue addValue(IMetadataValue copyFrom) throws IdASException {
        throw new NotImplementedException();
    }

    public void remove() throws IdASException {
        if (this._container != null) {
            MetadataNotification metaNotif = new MetadataNotification(this, "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_REMOVE", null);
            this._log.debug((Object)("Sending metadata remove notification - " + metaNotif.getAction() + ", " + metaNotif.getMeta().getMetaID().toString()));
            this._container.updateNotification(metaNotif);
        }
    }

    public boolean isSingleValued() {
        return false;
    }

    public void updateNotification(MetadataValueNotification metaValueNotif) throws IdASException {
        this._log.debug((Object)("Received metadata value notification - " + metaValueNotif.getAction() + ", " + metaValueNotif.getMetadataValue().toString()));
        this._log.debug((Object)("_containter " + (this._container != null ? this._container.toString() : "null")));
        if (this._container != null) {
            MetadataNotification metaNotif = new MetadataNotification(this, "urn:eclipse.higgins.idas.spi.MetadataNotification.UPDATE_VALUE_NOTIFY", metaValueNotif);
            this._container.updateNotification(metaNotif);
        }
        if (metaValueNotif.getAction() == "urn:eclipse.higgins.idas.spi.MetadataValueNotification.UPDATE_REMOVE") {
            this._values.remove(metaValueNotif.getMetadataValue());
        }
    }

    public void setContainer(IMetadataContainer container) {
        this._container = container;
    }

    public IMetadataContainer getContainer() {
        return this._container;
    }

    public boolean equals(IMetadata meta) throws IdASException {
        boolean bRet;
        if (meta.getMetaID() != this.getMetaID()) {
            bRet = false;
        } else {
            bRet = this.equals((IHasMetadata)meta);
            if (bRet) {
                Iterator iter = meta.getValues();
                while (iter.hasNext()) {
                    if (this._containsValue((IMetadataValue)iter.next())) continue;
                    bRet = false;
                    break;
                }
            }
        }
        return bRet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

