/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.spi;

import java.net.URI;
import java.util.Iterator;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IHasMetadata;
import org.eclipse.higgins.idas.api.IMetadata;
import org.eclipse.higgins.idas.api.INode;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.INodeModel;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicMetadataSet;
import org.eclipse.higgins.idas.spi.IAttributeContainer;
import org.eclipse.higgins.idas.spi.IMetadataContainer;

public abstract class BasicNode
implements INode,
IAttributeContainer,
IMetadataContainer {
    private IContext _context;
    private String _nodeId;
    private URI _type;
    private BasicAttributeSet _attrs;
    private BasicMetadataSet _metadata;

    public BasicNode(IContext context) throws IdASException {
        this(context, null, null, null, null);
    }

    public BasicNode(IContext context, URI type, String nodeId) throws IdASException {
        this(context, type, nodeId, null, null);
    }

    public BasicNode(IContext context, URI type, String nodeId, Iterator attributes, Iterator metadata) throws IdASException {
        this._context = context;
        this._type = type;
        this._nodeId = nodeId;
        this._attrs = new BasicAttributeSet(attributes, this, this._context);
        this._metadata = new BasicMetadataSet(metadata, this);
    }

    public IContext getContext() throws IdASException {
        return this._context;
    }

    public INodeModel getModel() throws IdASException {
        throw new NotImplementedException();
    }

    public URI getNodeType() throws IdASException {
        return this._type;
    }

    public String getNodeID() throws IdASException {
        return this._nodeId;
    }

    public IMetadata addMetadata(IMetadata copyFrom) throws IdASException {
        return this._metadata.addMetadata(copyFrom);
    }

    public IMetadata addMetadata(URI type) throws IdASException, InvalidTypeException {
        return this._metadata.addMetadata(type);
    }

    public IMetadata getMetadata(URI metadataID) throws IdASException {
        return this._metadata.getMetadata(metadataID);
    }

    public Iterator getMetadataSet() throws IdASException {
        return this._metadata.getMetadataSet();
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        return this._attrs.addAttribute(copyFrom);
    }

    public IAttribute addAttribute(URI type) throws IdASException, InvalidTypeException {
        return this._attrs.addAttribute(type);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        return this._attrs.getAttribute(attrID);
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        return this._attrs.getSingleValuedAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        return this._attrs.getAttributes();
    }

    protected BasicAttributeSet getBasicAttributeSet() {
        return this._attrs;
    }

    public void removeAttribute(URI attrID) throws IdASException {
        this._attrs.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        this._attrs.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        this._attrs.removeAttributeValue(attr);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        return this._attrs.equals(attributes);
    }

    protected BasicMetadataSet getBasicMetadataSet() {
        return this._metadata;
    }

    public boolean equals(IHasMetadata metadataSet) throws IdASException {
        return this._metadata.equals(metadataSet);
    }
}

