/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.conf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.conf.ConfContextUDIMetadata;

public class ConfEntityUDIMetadata
implements IEntityUDIMetadata {
    private static final Pattern PATTERN_SPLIT = Pattern.compile("(.+)(?<!\\\\)/(.+)");
    private String entityUDI;
    private IContextUDIMetadata contextUDIMetadata;
    private String entityID;

    ConfEntityUDIMetadata(String entityUDI) {
        this.entityUDI = entityUDI;
        this.contextUDIMetadata = null;
        this.entityID = null;
    }

    private void resolve() throws IdASException {
        Matcher matcher = PATTERN_SPLIT.matcher(this.entityUDI);
        if (matcher.matches()) {
            String contextUDI = matcher.group(1).replaceAll("\\/", "/");
            this.contextUDIMetadata = new ConfContextUDIMetadata(contextUDI);
            this.entityID = matcher.group(2).replaceAll("\\/", "/");
        } else {
            this.contextUDIMetadata = new ConfContextUDIMetadata(this.entityUDI);
            this.entityID = this.entityUDI;
        }
    }

    public IContextUDIMetadata getContextUDIMetadata() throws IdASException {
        if (this.contextUDIMetadata == null) {
            this.resolve();
        }
        return this.contextUDIMetadata;
    }

    public String getEntityID() throws IdASException {
        if (this.entityID == null) {
            this.resolve();
        }
        return this.entityID;
    }
}

