/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.google;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.google.GoogleUDIFactory;

public class GoogleEntityUDIMetadata
implements IEntityUDIMetadata {
    private String entityUDI;
    private IContextUDIMetadata contextUDIMetadata;
    private String entityID;

    GoogleEntityUDIMetadata(String entityUDI) {
        this.entityUDI = entityUDI;
        this.contextUDIMetadata = null;
        this.entityID = null;
    }

    private void resolve() throws IdASException {
        this.contextUDIMetadata = new IContextUDIMetadata(){

            public String[] getTypes() throws IdASException {
                return GoogleUDIFactory.TYPES_GOOGLE;
            }

            public String[] getAuthNMaterialsTypes() throws IdASException {
                return GoogleUDIFactory.AUTHNMATERIALS_TYPES_GOOGLE;
            }

            public String getAuthNMaterials() throws IdASException {
                return GoogleUDIFactory.AUTHNMATERIALS_GOOGLE;
            }

            public Map getConfiguration() throws IdASException {
                HashMap<String, String> connection = new HashMap<String, String>();
                connection.put("ConnectionType", "Google Contacts");
                connection.put("FeedURL", "http://www.google.com/m8/feeds/");
                connection.put("Projection", "thin");
                HashMap<String, HashMap<String, String>> configuration = new HashMap<String, HashMap<String, String>>();
                configuration.put("Connection", connection);
                return configuration;
            }
        };
        try {
            this.entityID = "http://www.google.com/m8/feeds/contacts/" + URLEncoder.encode(this.entityUDI, "UTF-8") + "/thin/0";
        }
        catch (UnsupportedEncodingException ex) {
            throw new IdASException((Throwable)ex);
        }
    }

    public IContextUDIMetadata getContextUDIMetadata() throws IdASException {
        if (this.contextUDIMetadata == null) {
            this.resolve();
        }
        return this.contextUDIMetadata;
    }

    public String getEntityID() throws IdASException {
        if (this.entityID == null) {
            this.resolve();
        }
        return this.entityID;
    }
}

