/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.idas.udi.impl.hashuri;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.udi.IContextUDIMetadata;
import org.eclipse.higgins.idas.udi.IEntityUDIMetadata;
import org.eclipse.higgins.idas.udi.impl.hashuri.HashURIUDIFactory;
import org.eclipse.higgins.idas.udi.util.RDFXRDSUtil;
import org.eclipse.higgins.idas.udi.util.XRDSContextUDIMetadata;
import org.eclipse.higgins.idas.udi.util.XRDSDownloader;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverFlags;
import org.openxri.resolve.ResolverState;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class HashURIEntityUDIMetadata
implements IEntityUDIMetadata {
    private String entityUDI;
    private IContextUDIMetadata contextUDIMetadata;
    private String entityID;

    HashURIEntityUDIMetadata(String entityUDI) {
        this.entityUDI = entityUDI;
        this.contextUDIMetadata = null;
        this.entityID = null;
    }

    private void resolve() throws IdASException {
        final String uri = this.entityUDI.substring(0, this.entityUDI.indexOf(35));
        String fragment = this.entityUDI.substring(this.entityUDI.indexOf(35) + 1);
        boolean rdf = RDFXRDSUtil.probeRDF(uri);
        if (rdf) {
            this.contextUDIMetadata = new IContextUDIMetadata(){

                public String[] getTypes() throws IdASException {
                    return HashURIUDIFactory.TYPES_RDF;
                }

                public String[] getAuthNMaterialsTypes() throws IdASException {
                    return HashURIUDIFactory.AUTHNMATERIALS_TYPES_RDF;
                }

                public String getAuthNMaterials() throws IdASException {
                    return HashURIUDIFactory.AUTHNMATERIALS_RDF;
                }

                public Map getConfiguration() throws IdASException {
                    HashMap configuration = new HashMap();
                    ArrayList<URI> uris = new ArrayList<URI>();
                    uris.add(URI.create(uri));
                    configuration.put("uris", uris);
                    return configuration;
                }
            };
            this.entityID = this.entityUDI;
        } else {
            this.contextUDIMetadata = new XRDSContextUDIMetadata(){

                protected void resolve() throws IdASException {
                    XRD xrd;
                    try {
                        URL url = new URL(uri);
                        xrd = XRDSDownloader.discoverXRDS(url).getFinalXRD();
                    }
                    catch (Exception ex) {
                        throw new IdASException("Cannot download XRDS from URL " + uri + ": " + ex.getMessage(), (Throwable)ex);
                    }
                    Resolver resolver = new Resolver();
                    for (int i = 0; i < HashURIUDIFactory.SEP_TYPES.length; ++i) {
                        try {
                            XRDS xrds = new XRDS();
                            ResolverFlags resolverFlags = new ResolverFlags();
                            resolverFlags.setNoDefaultT(true);
                            resolverFlags.setNoDefaultP(false);
                            resolverFlags.setNoDefaultM(false);
                            List services = resolver.selectServiceFromXRD(xrds, xrd, new XRI("$"), HashURIUDIFactory.SEP_TYPES[i], null, resolverFlags, new ResolverState());
                            if (services.size() <= 0) continue;
                            this.service = (Service)services.get(0);
                            break;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            };
            this.entityID = fragment;
        }
    }

    public IContextUDIMetadata getContextUDIMetadata() throws IdASException {
        if (this.contextUDIMetadata == null) {
            this.resolve();
        }
        return this.contextUDIMetadata;
    }

    public String getEntityID() throws IdASException {
        if (this.entityID == null) {
            this.resolve();
        }
        return this.entityID;
    }
}

